/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.client.gui;

import chappie.modulus.Modulus;
import chappie.modulus.client.gui.ChappModListWidget;
import chappie.modulus.client.gui.ModulusAboutButton;
import chappie.modulus.client.gui.TabButton;
import chappie.modulus.util.ClientUtil;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.HttpTexture;
import chappie.modulus.util.IHasTimer;
import chappie.modulus.util.IOneScaleScreen;
import chappie.modulus.util.ModRegistries;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8666;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class ModulusMainScreen
extends class_437
implements IOneScaleScreen {
    public static final class_2960 MENU = Modulus.id("textures/gui/sprites/menu.png");
    public static final class_8666 SPRITES = new class_8666(Modulus.id("widget/button"), Modulus.id("widget/button_disabled"), Modulus.id("widget/button_highlighted"));
    private static final class_2960 CHAPPIE_TEXTURE = ModulusMainScreen.getTexByName("chappie");
    private final class_437 lastScreen;
    private final List<TabButton> tabs = Lists.newArrayList();
    private final IHasTimer.Timer atChappieTimer = new IHasTimer.Timer(() -> 10, () -> false);
    private final Supplier<List<String>> links = CommonUtil.getTxtFromLink("https://raw.githubusercontent.com/ChappiePie/ModulusResources/main/links.txt");
    public List<class_364> pageWidgets = new ArrayList<class_364>();
    private int tabId = 0;
    private int canvasMinY;
    private int canvasMaxY;
    private ChappModListWidget modList;
    private long utilMillis;

    public ModulusMainScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43471((String)"gui.modulus.mainScreen"));
        this.lastScreen = lastScreen;
    }

    public static class_2960 getTexByName(String name) {
        class_2960 resourcelocation = Modulus.id("modulus_screen/" + name);
        File file = new File("config/modulus/data", name);
        return HttpTexture.byUrl(file, "https://raw.githubusercontent.com/ChappiePie/ModulusResources/main/%s.png".formatted(name), resourcelocation, Modulus.id("textures/gui/mods_author/%s.png".formatted(name)));
    }

    public void method_25393() {
        super.method_25393();
        if (this.modList != null) {
            this.modList.tick();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.canvasMinY = 58;
        this.canvasMaxY = this.field_22790 - 36;
        int halfWidth = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.field_22787.method_1507(this.lastScreen)).method_46433(halfWidth - 75, this.field_22790 - 30).method_46431());
        this.tabs.clear();
        int tabWidth = 100;
        int xPos = halfWidth - tabWidth;
        for (int i = 0; i < 2; ++i) {
            class_5250 component = class_2561.method_43471((String)"screen.modulus.tab.%s".formatted(i == 0 ? "mods" : "about"));
            TabButton tabButton = new TabButton(xPos, 40, tabWidth, 24, (class_2561)component.method_27696(ClientUtil.BOLD_MINECRAFT), i, () -> this.tabId);
            this.tabs.add(tabButton);
            this.method_37063((class_364)tabButton);
            xPos += tabWidth;
        }
        this.method_25395((class_364)this.tabs.get(this.tabId));
    }

    public <T extends class_364 & class_4068> ImmutableList<T> createModsPage() {
        this.modList = new ChappModListWidget(this, this.field_22789 - 18, 64, this.field_22790 - 42);
        this.modList.method_46421(6);
        return ImmutableList.of((Object)((Object)this.modList));
    }

    public <T extends class_364 & class_4068> ImmutableList<T> createAboutPage() {
        ArrayList<ModulusAboutButton> buttons = new ArrayList<ModulusAboutButton>();
        int canvasHeight = this.canvasMaxY - this.canvasMinY;
        for (int i = 0; i < 4; ++i) {
            int size = canvasHeight / 3;
            int height = this.canvasMinY + 7 + 20 + 2 + size / 8;
            int j = i == 0 || i == 2 ? 0 : size;
            int k = i > 1 ? size : 0;
            buttons.add(new ModulusAboutButton(this.field_22789 / 4 - size + j, height + k, size, 105 + i * 16, MENU, this.links, i));
        }
        return (ImmutableList)buttons.stream().collect(ImmutableList.toImmutableList());
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        long l = class_156.method_658();
        if (l - this.utilMillis > 10L) {
            this.utilMillis = l;
            this.atChappieTimer.update();
            for (class_364 renderable : this.method_25396()) {
                if (!(renderable instanceof IHasTimer)) continue;
                IHasTimer timer = (IHasTimer)renderable;
                for (IHasTimer.Timer t : timer.timers()) {
                    t.update();
                }
            }
        }
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.method_52707(class_1921::method_62277, SPRITES.method_52729(true, false), this.field_22789 / 2 - 60, 3, 120, 32, class_9848.method_61317((float)1.0f));
        class_4587 pPoseStack = guiGraphics.method_51448();
        pPoseStack.method_22903();
        pPoseStack.method_46416((float)this.field_22789 / 4.0f, 4.0f, 0.0f);
        pPoseStack.method_22905(0.5f, 0.5f, 1.0f);
        int labelXPos = this.field_22789 / 2;
        int labelYPos = 10;
        guiGraphics.method_25302(class_1921::method_62277, MENU, labelXPos - 52, labelYPos, 0.0f, 0.0f, 104, 29, 104, 29, 256, 256);
        int lineColor = class_9848.method_61324((int)255, (int)46, (int)51, (int)53);
        guiGraphics.method_25294(labelXPos - 51 - 16, (labelYPos += 30) + 3, labelXPos - 51 + 104 + 16, labelYPos + 5, lineColor);
        guiGraphics.method_25294(labelXPos - 52 - 16, labelYPos + 2, labelXPos - 52 + 104 + 16, labelYPos + 4, lineColor);
        pPoseStack.method_22909();
        if (this.tabId == 1) {
            int canvasHeight = this.canvasMaxY - this.canvasMinY;
            this.renderTitle(guiGraphics, (class_2561)class_2561.method_43471((String)"screen.modulus.socials").method_27696(ClientUtil.BOLD_MINECRAFT), (int)((float)this.field_22789 / 4.0f), this.canvasMinY + 10);
            int c = class_9848.method_61324((int)20, (int)255, (int)255, (int)255);
            int x = 0;
            int minY = this.canvasMinY + 10;
            int maxY = this.canvasMaxY - 8;
            guiGraphics.method_25294(x - 2 + 30, minY, x + 2 + 30, maxY, c);
            guiGraphics.method_25294(x + 2 + 30, minY, x + 6 + 30, minY + 4, c);
            x = this.field_22789 / 2;
            guiGraphics.method_25294(x - 2 + 30, minY, x + 2 + 30, maxY - 4, c);
            guiGraphics.method_25294(x + 2 + 30, minY, x + 6 + 30, minY + 4, c);
            guiGraphics.method_25294(x - 2 - 30, minY, x + 2 - 30, maxY - 4, c);
            guiGraphics.method_25294(x - 2 - 30, minY, x - 6 - 30, minY + 4, c);
            x = this.field_22789;
            guiGraphics.method_25294(x - 2 - 30, minY, x + 2 - 30, maxY, c);
            guiGraphics.method_25294(x - 2 - 30, minY, x - 6 - 30, minY + 4, c);
            guiGraphics.method_25294(32, maxY, x - 2 - 30, maxY - 4, c);
            class_5250 s = class_2561.method_43471((String)"screen.modulus.creator").method_27696(ClientUtil.BOLD_MINECRAFT);
            x = (int)((float)this.field_22789 * 0.75f);
            int y = this.canvasMinY + 10;
            this.renderTitle(guiGraphics, (class_2561)s, x, y);
            int width = (int)((double)canvasHeight / 1.27);
            int x1 = x - width / 2;
            int y1 = y + 25;
            guiGraphics.method_44379(x1, y1, x1 + width, y1 + (int)((double)canvasHeight / 1.5));
            guiGraphics.method_25290(class_1921::method_62277, class_437.field_49511, x1, y1, 0.0f, 0.0f, width, (int)((float)canvasHeight / 1.5f), 32, 32);
            this.atChappieTimer.predicate = () -> this.isMouseOverObj(pMouseX, pMouseY, x1, y1, width, (float)canvasHeight / 1.5f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float f = this.atChappieTimer.value(ClientUtil.getPartialTick());
            float mouseXAdd = ((float)(pMouseX - x1) - (float)width / 2.0f) / 10.0f * f;
            float mouseYAdd = Math.max(-40.0f, (float)(pMouseY - y1) - (float)((int)((float)canvasHeight / 1.5f)) / 2.0f) / 10.0f * f;
            ClientUtil.blit(guiGraphics, CHAPPIE_TEXTURE, (float)x1 + 11.5f - (f *= 10.0f) / 2.0f + mouseXAdd, (float)y1 - f / 2.0f + mouseYAdd, 0.0f, 0.0f, (float)canvasHeight / 1.6f + f, (float)canvasHeight / 1.5f + f, 1310.0f, 1440.0f, 1310.0f, 1440.0f, -1);
            guiGraphics.method_44380();
            class_5250 pTooltip = class_2561.method_43470((String)"ChappiePie");
            float f2 = pMouseX;
            float f3 = pMouseY;
            float f4 = (float)(x - 1) - (float)this.field_22787.field_1772.method_27525((class_5348)s) * 0.75f;
            float f5 = y - 1;
            float f6 = (float)this.field_22787.field_1772.method_27525((class_5348)s) * 0.75f * 2.0f;
            Objects.requireNonNull(this.field_22787.field_1772);
            if (this.isMouseOverObj(f2, f3, f4, f5, f6, 9.0f * 1.5f - 1.0f)) {
                pPoseStack.method_22903();
                pPoseStack.method_46416(0.0f, 0.0f, 50.0f);
                int i = pMouseX + 2;
                int j = pMouseY - 10;
                int k = this.field_22793.method_27525((class_5348)pTooltip);
                guiGraphics.method_25296(i - 3, j - 3, i + k + 3, j + 8 + 3, -1073741824, -1073741824);
                guiGraphics.method_51439(this.field_22793, (class_2561)pTooltip, i, j, 0xFFFFFF, true);
                pPoseStack.method_22909();
            }
        }
    }

    public void method_25420(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25420(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private boolean isMouseOverObj(float pMouseX, float pMouseY, float x, float y, float width, float height) {
        return pMouseX >= x && pMouseY >= y && pMouseX <= x + width && pMouseY <= y + height;
    }

    private void renderTitle(class_332 guiGraphics, class_2561 component, int x, int y) {
        class_4587 pPoseStack = guiGraphics.method_51448();
        pPoseStack.method_22903();
        pPoseStack.method_46416((float)(x + 1), (float)y, 0.0f);
        pPoseStack.method_22905(1.5f, 1.5f, 1.0f);
        guiGraphics.method_27534(this.field_22787.field_1772, component, 0, 0, -1);
        pPoseStack.method_22909();
        y += 14;
        int color = -1;
        for (int k = 0; k < 2; ++k) {
            if (k == 0) {
                color = class_9848.method_61318((float)1.0f, (float)0.25f, (float)0.25f, (float)0.25f);
                x += 2;
                y += 2;
            }
            int length = this.field_22787.field_1772.method_27525((class_5348)component) + 5;
            guiGraphics.method_25294(x - length, y, x + length, y + 2, color);
            guiGraphics.method_25294(x - length + 2, y - 2, x - length + 4, y + 4, color);
            guiGraphics.method_25294(x + length - 2, y - 2, x + length - 4, y + 4, color);
            if (k != 0) continue;
            x -= 2;
            y -= 2;
            color = -1;
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen instanceof class_433 ? null : this.lastScreen);
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModRegistries.CLOSE_BUTTON, (float)1.0f));
    }

    @Override
    public int scale(int scale) {
        return 3;
    }

    public void method_25395(@Nullable class_364 pListener) {
        if (pListener instanceof TabButton) {
            TabButton b = (TabButton)pListener;
            if (this.method_25399() != b) {
                this.tabId = b.tabId;
                for (class_364 pageWidget : this.pageWidgets) {
                    this.method_37066(pageWidget);
                }
                this.pageWidgets.clear();
                for (class_364 listener : switch (this.tabId) {
                    case 0 -> this.createModsPage();
                    default -> this.createAboutPage();
                }) {
                    this.method_37063(listener);
                    this.pageWidgets.add(listener);
                }
            }
        }
        super.method_25395(pListener);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (class_437.method_25441()) {
            int i = this.getNextTabIndex(pKeyCode);
            if (i != -1) {
                this.method_25395((class_364)this.tabs.get(class_3532.method_15340((int)i, (int)0, (int)(this.tabs.size() - 1))));
                return true;
            }
        } else {
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }
        return false;
    }

    private int getNextTabIndex(int pKeyCode) {
        int i;
        if (pKeyCode >= 49 && pKeyCode <= 57) {
            return pKeyCode - 49;
        }
        if (pKeyCode == 258 && (i = this.tabId) != -1) {
            int j = class_437.method_25442() ? i - 1 : i + 1;
            return Math.floorMod(j, this.tabs.size());
        }
        return -1;
    }
}

