/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.common.ability.base;

import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.AbilityClientProperties;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.networking.ModNetworking;
import chappie.modulus.networking.client.ClientSyncAbility;
import chappie.modulus.util.KeyMap;
import chappie.modulus.util.data.DataAccessor;
import chappie.modulus.util.data.DataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class Ability {
    public static final DataAccessor<Boolean> ENABLED = new DataAccessor<Boolean>("enabled", DataAccessor.DataSerializer.BOOLEAN);
    public final class_1309 entity;
    public final AbilityBuilder builder;
    public final DataManager dataManager = new DataManager(this);
    public final KeyMap keys = new KeyMap();
    public final AbilityBuilder.ConditionManager conditionManager;
    public final List<AbilityClientProperties> clientProperties = new ArrayList<AbilityClientProperties>();
    public int enabledTicks;

    public Ability(class_1309 entity, AbilityBuilder builder) {
        this.entity = entity;
        this.builder = builder;
        this.defineData();
        this.conditionManager = new AbilityBuilder.ConditionManager(this);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.initializeClient(this.clientProperties::add);
        }
    }

    public void defineData() {
        this.dataManager.define(ENABLED, false);
    }

    public void onDataUpdated(DataAccessor<?> accessor) {
        if (accessor == ENABLED) {
            this.entity.method_18382();
        }
    }

    public void initializeClient(Consumer<AbilityClientProperties> consumer) {
    }

    public void updateTick(class_1309 entity) {
        if (!entity.method_5770().field_9236) {
            if (entity instanceof class_1657) {
                this.dataManager.set(ENABLED, this.conditionManager.test("enabling"));
            } else if (entity.field_6012 % 600 == 1) {
                this.dataManager.set(ENABLED, !this.isEnabled());
            }
        }
        this.update(entity, this.isEnabled());
        this.conditionManager.conditions().forEach(Condition::update);
        this.enabledTicks = this.isEnabled() ? ++this.enabledTicks : 0;
    }

    public void update(class_1309 entity, boolean enabled) {
    }

    public boolean isEnabled() {
        return this.dataManager.get(ENABLED);
    }

    public boolean isHidden() {
        return this.builder.hidden;
    }

    public void clientProperties(Consumer<AbilityClientProperties> consumer) {
        for (AbilityClientProperties clientProperty : this.clientProperties) {
            consumer.accept(clientProperty);
        }
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10566("Data", (class_2520)this.dataManager.serializeNBT());
        tag.method_10566("Conditions", (class_2520)this.conditionManager.serializeNBT());
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.dataManager.deserializeNBT(tag.method_10562("Data"));
        this.conditionManager.deserializeNBT(tag.method_10562("Conditions"));
    }

    public void sync(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ModNetworking.send(new ClientSyncAbility(player.method_5628(), this.builder.id, this.serializeNBT()), player);
        }
    }

    public void syncToAll(class_1297 entity) {
        if (!entity.method_5770().field_9236) {
            ModNetworking.sendToTrackingEntityAndSelf(new ClientSyncAbility(entity.method_5628(), this.builder.id, this.serializeNBT()), entity);
        }
    }
}

