/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.common.ability.base;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityType;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.common.capability.PowerCap;
import chappie.modulus.util.data.DataAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public class AbilityBuilder {
    public final String id;
    public final AbilityType type;
    final HashMap<String, List<Function<Ability, Condition>>> funcConditions = Maps.newHashMap();
    class_2561 displayName = null;
    boolean hidden;
    List<Consumer<Ability>> additionalData = Lists.newArrayList();

    AbilityBuilder(String id, AbilityType type) {
        this.id = id;
        this.type = type;
    }

    public static AbilityBuilder of(String name, AbilityType type) {
        return new AbilityBuilder(name, type);
    }

    public AbilityBuilder hide() {
        this.hidden = true;
        return this;
    }

    public AbilityBuilder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public <T> AbilityBuilder change(DataAccessor<T> accessor, T value) {
        this.additionalData.add(a -> a.dataManager.set(accessor, value));
        return this;
    }

    public AbilityBuilder additionalData(Consumer<Ability> abilityConsumer) {
        this.additionalData.add(abilityConsumer);
        return this;
    }

    public AbilityBuilder condition(Function<Ability, Condition> condition, String ... methods) {
        for (String method : methods) {
            ArrayList conditions = this.funcConditions.containsKey(method) ? this.funcConditions.get(method) : Lists.newArrayList();
            conditions.add(condition);
            this.funcConditions.put(method, conditions);
        }
        return this;
    }

    public Ability build(class_1309 livingEntity) {
        return this.type.create(livingEntity, this);
    }

    public class_2561 displayName() {
        return this.displayName == null ? this.type.displayName() : this.displayName;
    }

    public static class ConditionManager {
        private final HashMap<String, List<Condition>> conditions = Maps.newHashMap();
        private final Ability ability;

        public ConditionManager(Ability ability) {
            this.ability = ability;
            for (Map.Entry<String, List<Function<Ability, Condition>>> e : ability.builder.funcConditions.entrySet()) {
                this.conditions.put(e.getKey(), e.getValue().stream().map(func -> (Condition)func.apply(ability)).collect(Collectors.toList()));
            }
            for (Condition condition : this.conditions()) {
                condition.init();
            }
        }

        public boolean test(String method) {
            PowerCap cap;
            boolean b = true;
            List<Condition> conditions = this.conditionsFor(method);
            if (conditions != null) {
                for (Condition condition : conditions) {
                    if (condition.get()) continue;
                    b = false;
                }
            }
            if (!((cap = PowerCap.getCap(this.ability.entity)) == null || cap.getSuperpower() != null && cap.getSuperpower().getBuilders().contains(this.ability.builder))) {
                return false;
            }
            return b;
        }

        public List<Condition> conditionsFor(String method) {
            return this.conditions.getOrDefault(method, List.of());
        }

        public List<Condition> conditions() {
            ArrayList list = Lists.newArrayList();
            for (List<Condition> value : this.conditions.values()) {
                list.addAll(value);
            }
            return list;
        }

        public HashMap<String, List<Condition>> methodConditions() {
            return this.conditions;
        }

        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            for (Map.Entry<String, List<Condition>> e : this.conditions.entrySet()) {
                class_2499 conditions = new class_2499();
                for (Condition condition : e.getValue()) {
                    conditions.add((Object)condition.serializeNBT());
                }
                tag.method_10566(e.getKey(), (class_2520)conditions);
            }
            return tag;
        }

        public void deserializeNBT(class_2487 nbt) {
            for (String key : nbt.method_10541()) {
                class_2499 conditions = nbt.method_10554(key, 10);
                for (int i = 0; i < conditions.size(); ++i) {
                    List<Condition> c = this.conditions.get(key);
                    if (c == null || c.get(i) == null) continue;
                    c.get(i).deserializeNBT(conditions.method_10602(i));
                }
            }
        }
    }
}

