/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.common.ability.base.condition;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.util.KeyMap;
import java.util.function.Supplier;
import net.minecraft.class_2487;

public class DoubleKeyCondition
extends Condition {
    public KeyMap.KeyType keyType = KeyMap.KeyType.JUMP;
    private Supplier<Boolean> shouldStop = () -> false;
    private boolean isPressed;
    private boolean enabled;
    private int keyTriggerTime;

    public DoubleKeyCondition(Ability ability) {
        super(ability, c -> {
            if (!(c instanceof DoubleKeyCondition)) return false;
            DoubleKeyCondition k = (DoubleKeyCondition)c;
            if (!k.enabled) return false;
            return true;
        });
    }

    @Override
    public void update() {
        super.update();
        if (this.keyTriggerTime > 0) {
            --this.keyTriggerTime;
        }
        this.isPressed = this.ability.keys.isDown(this.keyType);
        if (this.shouldStop.get().booleanValue()) {
            this.enabled = false;
        }
    }

    @Override
    public void keyEvent() {
        super.keyEvent();
        if (!this.isPressed && this.ability.keys.isDown(this.keyType) && !this.shouldStop.get().booleanValue()) {
            if (this.keyTriggerTime == 0) {
                this.keyTriggerTime = 8;
            } else {
                this.enabled = !this.enabled;
                this.keyTriggerTime = 0;
            }
        }
    }

    public DoubleKeyCondition shouldStop(Supplier<Boolean> shouldStop) {
        this.shouldStop = shouldStop;
        return this;
    }

    public DoubleKeyCondition keyType(KeyMap.KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        tag.method_10556("enabled", this.enabled);
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.enabled = nbt.method_10577("enabled");
    }
}

