/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.common.ability.base.condition;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.condition.Condition;
import chappie.modulus.util.KeyMap;
import net.minecraft.class_2487;

public class KeyCondition
extends Condition {
    public KeyMap.KeyType keyType = KeyMap.KeyType.FIRST;
    protected Action action = Action.ACTION;
    protected boolean enabled;

    public KeyCondition(Ability ability) {
        super(ability, c -> {
            if (!(c instanceof KeyCondition)) return false;
            KeyCondition k = (KeyCondition)c;
            if (!k.enabled) return false;
            return true;
        });
    }

    @Override
    public void update() {
        super.update();
        if (this.action == Action.ACTION) {
            this.enabled = false;
        }
    }

    @Override
    public void keyEvent() {
        super.keyEvent();
        if (this.ability.keys.isDown(this.keyType)) {
            this.enabled = this.action != Action.TOGGLE || !this.enabled;
        } else if (this.action == Action.HELD) {
            this.enabled = false;
        }
    }

    public KeyCondition keyType(KeyMap.KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public KeyCondition action(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        if (this.action == Action.TOGGLE) {
            tag.method_10556("enabled", this.enabled);
        }
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        if (this.action == Action.TOGGLE) {
            this.enabled = nbt.method_10577("enabled");
        }
    }

    public static enum Action {
        ACTION,
        TOGGLE,
        HELD;

    }
}

