/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.common.capability;

import chappie.modulus.Modulus;
import chappie.modulus.client.ClientEvents;
import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.ability.base.AbilityBuilder;
import chappie.modulus.common.ability.base.Superpower;
import chappie.modulus.util.CommonUtil;
import chappie.modulus.util.IHasTimer;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistryV3;
import org.ladysnake.cca.api.v3.component.ComponentV3;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class PowerCap
implements AutoSyncedComponent,
CommonTickingComponent,
ComponentV3 {
    public static final ComponentKey<PowerCap> KEY = ComponentRegistryV3.INSTANCE.getOrCreate(Modulus.id("powers"), PowerCap.class);
    private final class_1309 livingEntity;
    private final Map<AbilityBuilder, Ability> abilities = Maps.newLinkedHashMap();
    private Superpower superpower;

    public PowerCap(class_1309 livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Nullable
    public static PowerCap getCap(Object provider) {
        return KEY.maybeGet(provider).orElse(null);
    }

    public Superpower getSuperpower() {
        return this.superpower;
    }

    public void setSuperpower(Superpower superpower) {
        this.superpower = superpower;
        this.abilities.values().forEach(value -> value.update(this.livingEntity, false));
        this.abilities.clear();
        if (superpower != null) {
            for (AbilityBuilder builder : superpower.getBuilders()) {
                this.abilities.put(builder, builder.build(this.livingEntity));
            }
        }
        this.syncToAll();
    }

    public Collection<Ability> getAbilities() {
        return this.abilities.values();
    }

    public Ability getAbility(String key) {
        for (Ability ability : this.abilities.values()) {
            if (!ability.builder.id.equals(key)) continue;
            return ability;
        }
        return null;
    }

    public void sync() {
        KEY.sync((Object)this.livingEntity);
    }

    public void syncToAll() {
        this.sync();
        for (class_1309 livingEntity : this.livingEntity.method_5770().method_18456()) {
            if (!(livingEntity instanceof class_3222)) continue;
            class_3222 player = (class_3222)livingEntity;
            if (this.livingEntity == livingEntity) continue;
            KEY.sync((Object)player);
        }
    }

    public void tick() {
        if (this.livingEntity.method_5770().field_9236) {
            class_1309 class_13092 = this.livingEntity;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                ClientEvents.playerTick(player);
            } else {
                for (Ability ability : CommonUtil.getAbilities((class_1297)this.livingEntity)) {
                    if (!(ability instanceof IHasTimer)) continue;
                    IHasTimer iHasTimer = (IHasTimer)((Object)ability);
                    iHasTimer.timers().forEach(IHasTimer.Timer::update);
                }
            }
        } else {
            for (Ability ability : CommonUtil.getAbilities((class_1297)this.livingEntity)) {
                if (!(ability instanceof IHasTimer)) continue;
                IHasTimer iHasTimer = (IHasTimer)((Object)ability);
                iHasTimer.timers().forEach(IHasTimer.Timer::update);
            }
        }
        for (Ability ability : CommonUtil.getAbilities((class_1297)this.livingEntity)) {
            ability.updateTick(this.livingEntity);
        }
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2487 compoundTag = tag.method_10562("Superpower");
        this.abilities.clear();
        if (!compoundTag.method_10558("Id").isEmpty()) {
            Superpower superpower;
            this.superpower = superpower = (Superpower)Superpower.REGISTRY.method_63535(class_2960.method_12829((String)compoundTag.method_10558("Id")));
            if (superpower != null) {
                class_2487 abilities = compoundTag.method_10562("Abilities");
                for (String key : abilities.method_10541()) {
                    class_2487 nbt = abilities.method_10562(key);
                    AbilityBuilder builder = superpower.getBuilderByName(key);
                    if (builder == null) continue;
                    Ability ability = builder.build(this.livingEntity);
                    ability.deserializeNBT(nbt);
                    this.abilities.put(builder, ability);
                }
            }
        } else {
            this.superpower = null;
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2487 superpower = new class_2487();
        if (this.superpower != null) {
            superpower.method_10582("Id", Objects.requireNonNull(Superpower.REGISTRY.method_10221((Object)this.superpower)).toString());
            class_2487 abilities = new class_2487();
            this.abilities.forEach((s, a) -> abilities.method_10566(s.id, (class_2520)a.serializeNBT()));
            superpower.method_10566("Abilities", (class_2520)abilities);
        }
        tag.method_10566("Superpower", (class_2520)superpower);
    }
}

