/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.networking;

import chappie.modulus.Modulus;
import chappie.modulus.networking.client.ClientKeyInput;
import chappie.modulus.networking.client.ClientSyncAbility;
import chappie.modulus.networking.client.ClientSyncData;
import chappie.modulus.networking.server.ServerKeyInput;
import chappie.modulus.networking.server.ServerSetData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ModNetworking {
    public static void registerMessages() {
        PayloadTypeRegistry.playC2S().register(ServerSetData.PACKET, ServerSetData.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ServerSetData.PACKET, (packet, context) -> packet.handle(context.player(), context.responseSender()));
        PayloadTypeRegistry.playC2S().register(ServerKeyInput.PACKET, ServerKeyInput.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ServerKeyInput.PACKET, (packet, context) -> packet.handle(context.player(), context.responseSender()));
        Modulus.LOGGER.debug("Registered server network");
    }

    public static void registerClientMessages() {
        PayloadTypeRegistry.playS2C().register(ClientSyncAbility.PACKET, ClientSyncAbility.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ClientSyncAbility.PACKET, (packet, context) -> packet.handle(context.player(), context.responseSender()));
        PayloadTypeRegistry.playS2C().register(ClientSyncData.PACKET, ClientSyncData.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ClientSyncData.PACKET, (packet, context) -> packet.handle(context.player(), context.responseSender()));
        PayloadTypeRegistry.playS2C().register(ClientKeyInput.PACKET, ClientKeyInput.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ClientKeyInput.PACKET, (packet, context) -> packet.handle(context.player(), context.responseSender()));
        Modulus.LOGGER.debug("Registered client network");
    }

    public static void sendToServer(class_8710 packet) {
        ClientPlayNetworking.send((class_8710)packet);
    }

    public static void send(class_8710 packet, class_3222 player) {
        try {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
        catch (Throwable throwable) {
            throwable.fillInStackTrace();
        }
    }

    public static void sendToTrackingEntityAndSelf(class_8710 packet, class_1297 entityToTrack) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_1297)entityToTrack)) {
            ModNetworking.send(packet, trackingPlayer);
        }
        if (entityToTrack instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entityToTrack;
            ModNetworking.send(packet, serverPlayer);
        }
    }

    public static void sendToEntitiesTrackingChunk(class_8710 packet, class_3218 level, class_2338 blockPos) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_3218)level, (class_2338)blockPos)) {
            ModNetworking.send(packet, trackingPlayer);
        }
    }
}

