/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.util;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.common.capability.PowerCap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_742;
import net.minecraft.class_8685;

public class CommonUtil {
    /*
     * Enabled aggressive block sorting
     */
    public static List<Ability> getAbilities(class_1297 entity) {
        ArrayList<Ability> list = new ArrayList<Ability>();
        PowerCap cap = PowerCap.getCap(entity);
        if (cap == null) {
            return list;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (player.field_13974 != null) {
                if (player.method_7325()) return list;
                list.addAll(cap.getAbilities());
                return list;
            }
        }
        list.addAll(cap.getAbilities());
        return list;
    }

    public static <T> List<T> listOfType(Class<T> type, Collection<?> list) {
        return list.stream().filter(x -> type.isAssignableFrom(x.getClass())).map(type::cast).collect(Collectors.toList());
    }

    public static boolean smallArms(class_1297 entity) {
        if (entity instanceof class_742) {
            return ((class_742)entity).method_52814().comp_1629().equals((Object)class_8685.class_7920.field_41122);
        }
        return false;
    }

    public static void spawnParticleForAll(class_1937 world, class_2394 particleIn, boolean longDistanceIn, class_243 posVc3d, class_243 offsetVc3d, float speedIn, int countIn) {
        for (class_3222 player : world.method_18467(class_3222.class, CommonUtil.boxWithRange(posVc3d, 20.0))) {
            player.field_13987.method_14364((class_2596)new class_2675(particleIn, longDistanceIn, true, posVc3d.field_1352, posVc3d.field_1351, posVc3d.field_1350, (float)offsetVc3d.field_1352, (float)offsetVc3d.field_1351, (float)offsetVc3d.field_1350, speedIn, countIn));
        }
    }

    public static void setAttribute(class_1309 entity, class_2960 name, class_6880<class_1320> attribute, double amount, class_1322.class_1323 operation) {
        class_1324 instance = entity.method_5996(attribute);
        if (instance == null || entity.method_5770().field_9236) {
            return;
        }
        class_1322 modifier = instance.method_6199(name);
        if (modifier != null && (amount == 0.0 || modifier.comp_2449() != amount || modifier.comp_2450() != operation)) {
            instance.method_6200(name);
            return;
        }
        if (modifier == null && amount != 0.0) {
            instance.method_26835(new class_1322(name, amount, operation));
        }
    }

    public static class_238 boxWithRange(class_243 vec3, double range) {
        return new class_238(vec3, vec3).method_1014(range);
    }

    public static class_239 pick(class_1297 entity, double distance) {
        class_239 hitResult = entity.method_5745(distance, 1.0f, false);
        class_243 eyePos = entity.method_5836(1.0f);
        class_243 viewVector = entity.method_5828(1.0f).method_1021(distance);
        class_238 aabb = entity.method_5829().method_18804(viewVector);
        double d = hitResult.method_17784().method_1025(eyePos);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)entity, (class_243)eyePos, (class_243)eyePos.method_1019(viewVector), (class_238)aabb, e -> !e.method_7325() && e.method_5863(), (double)d);
        if (entityHitResult != null && !entity.method_5626(entityHitResult.method_17782()) && (eyePos.method_1025(entityHitResult.method_17784()) < hitResult.method_17784().method_1025(eyePos) || hitResult.method_17783() == class_239.class_240.field_1333)) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    public static Supplier<List<String>> getTxtFromLink(String link) {
        ArrayList content = new ArrayList();
        CompletableFuture.runAsync(() -> {
            try {
                String line;
                URL url = new URL(link);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    content.add(line);
                }
                bufferedReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, (Executor)class_156.method_18349());
        return () -> content;
    }

    public static Supplier<JsonObject> getJsonFromLink(String link) {
        AtomicReference<JsonObject> jsonObject = new AtomicReference<JsonObject>(new JsonObject());
        CompletableFuture.runAsync(() -> {
            try (InputStream url = new URL(link).openStream();){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url));
                JsonElement root = JsonParser.parseReader((Reader)bufferedReader);
                bufferedReader.close();
                assert (root != null);
                jsonObject.set(root.getAsJsonObject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return jsonObject::get;
    }

    public static List<class_2561> parseDescriptionLines(JsonElement jsonElement) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (jsonElement != null) {
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    lines.addAll(CommonUtil.parseDescriptionLines(jsonArray.get(i)));
                }
            } else if (jsonElement.isJsonObject()) {
                lines.add((class_2561)class_2561.class_2562.method_10872((JsonElement)jsonElement, (class_7225.class_7874)class_5455.field_40585));
            } else if (jsonElement.isJsonPrimitive()) {
                lines.add((class_2561)class_2561.method_43470((String)jsonElement.getAsString()));
            }
        }
        return lines;
    }
}

