/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.util;

import chappie.modulus.Modulus;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class HttpTexture
implements AutoCloseable {
    private final class_1060 textureManager;
    private final class_2960 textureLocation;
    private final class_2960 withoutInternet;
    private final String urlString;
    @Nullable
    private final File file;
    @Nullable
    private class_1043 texture;
    private boolean closed;

    private HttpTexture(class_1060 textureManager, @Nullable File file, String urlString, class_2960 textureLocation, class_2960 withoutInternet) {
        this.textureManager = textureManager;
        this.file = file;
        this.urlString = urlString;
        this.textureLocation = textureLocation;
        this.withoutInternet = withoutInternet == null ? Modulus.id("textures/gui/white.png") : withoutInternet;
    }

    public static class_2960 byUrl(@Nullable File file, String urlString, class_2960 textureLocation, @Nullable class_2960 withoutInternet) {
        HttpTexture texture = new HttpTexture(class_310.method_1551().method_1531(), file, urlString, textureLocation, withoutInternet);
        texture.loadIcon();
        return texture.textureLocation;
    }

    public void upload(class_1011 image) {
        if (image.method_4307() > 0 && image.method_4323() > 0) {
            try {
                this.checkOpen();
                if (this.texture == null) {
                    this.texture = new class_1043(image);
                } else {
                    this.texture.method_4526(image);
                    this.texture.method_4524();
                }
                this.textureManager.method_4616(this.textureLocation, (class_1044)this.texture);
            }
            catch (Throwable var3) {
                image.close();
                this.clear();
                throw var3;
            }
        } else {
            image.close();
            throw new IllegalArgumentException("Icon must be 64x64, but was " + image.method_4307() + "x" + image.method_4323());
        }
    }

    public void clear() {
        this.checkOpen();
        if (this.texture != null) {
            this.textureManager.method_4615(this.textureLocation);
            this.texture.close();
            this.texture = null;
        }
    }

    public class_2960 textureLocation() {
        return this.texture != null ? this.textureLocation : this.withoutInternet;
    }

    @Override
    public void close() {
        this.clear();
        this.closed = true;
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Texture already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIcon() {
        try {
            InputStream inputStream = null;
            if (this.file != null && this.file.isFile()) {
                Modulus.LOGGER.debug("Loading http texture from local cache ({})", (Object)this.file);
                inputStream = new FileInputStream(this.file);
            } else {
                HttpURLConnection httpURLConnection = null;
                Modulus.LOGGER.debug("Downloading http texture from {} to {}", (Object)this.urlString, (Object)this.file);
                try {
                    httpURLConnection = (HttpURLConnection)new URL(this.urlString).openConnection(class_310.method_1551().method_1487());
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(false);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() / 100 == 2) {
                        if (this.file != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)this.file);
                            inputStream = new FileInputStream(this.file);
                        } else {
                            inputStream = httpURLConnection.getInputStream();
                        }
                    }
                }
                catch (Exception var6) {
                    Modulus.LOGGER.error("Couldn't download http texture", (Throwable)var6);
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            try {
                this.upload(class_1011.method_4309((InputStream)inputStream));
            }
            catch (Throwable var6) {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable var5) {
                        var6.addSuppressed(var5);
                    }
                }
                throw var6;
            }
            ((InputStream)inputStream).close();
        }
        catch (Throwable var7) {
            Modulus.LOGGER.error("Invalid texture for url {}", (Object)this.urlString, (Object)var7);
        }
    }
}

