/*
 * Decompiled with CFR 0.152.
 */
package chappie.modulus.util.data;

import chappie.modulus.common.ability.base.Ability;
import chappie.modulus.networking.ModNetworking;
import chappie.modulus.networking.client.ClientSyncData;
import chappie.modulus.networking.server.ServerSetData;
import chappie.modulus.util.data.DataAccessor;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import org.slf4j.Logger;

public class DataManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<DataAccessor<?>, DataValue<?>> dataMap = Maps.newHashMap();
    private final Ability ability;

    public DataManager(Ability ability) {
        this.ability = ability;
    }

    public <T> DataManager define(DataAccessor<T> accessor, T initialValue) {
        return this.define(accessor, initialValue, true, true);
    }

    public <T> DataManager define(DataAccessor<T> accessor, T initialValue, boolean saveAfterRejoin) {
        return this.define(accessor, initialValue, saveAfterRejoin, true);
    }

    public <T> DataManager define(DataAccessor<T> accessor, T initialValue, boolean saveAfterRejoin, boolean synchronizeWithOthers) {
        if (!this.dataMap.containsKey(accessor)) {
            this.dataMap.put(accessor, new DataValue<T>(accessor, initialValue, saveAfterRejoin, synchronizeWithOthers));
        } else {
            LOGGER.error("Cannot define the data with id: %s".formatted(accessor.key()));
        }
        return this;
    }

    public <T> DataManager set(DataAccessor<T> accessor, T value) {
        DataValue<T> dataValue = this.getDataValue(accessor);
        class_1309 entity = this.ability.entity;
        if (dataValue.get() != value) {
            dataValue.set(value);
            this.ability.onDataUpdated(accessor);
            if (!entity.method_5770().field_9236 && dataValue.synchronizeWithOthers()) {
                ModNetworking.sendToTrackingEntityAndSelf(new ClientSyncData(entity.method_5628(), accessor.key(), this.ability.builder.id, dataValue.serialize(new class_2487(), true)), (class_1297)entity);
            }
        }
        return this;
    }

    public <T> DataManager setFromClient(DataAccessor<T> accessor, T value) {
        DataValue<T> dataValue = this.getDataValue(accessor);
        if (this.ability.entity.method_5770().field_9236 && dataValue.get() != value) {
            ModNetworking.sendToServer(new ServerSetData(accessor.key(), this.ability.builder.id, dataValue.serialize(new class_2487(), value, true)));
        }
        return this;
    }

    public <T> DataValue<T> getDataValue(DataAccessor<T> accessor) {
        return this.dataMap.get(accessor);
    }

    public <T> T get(DataAccessor<T> accessor) {
        return this.getDataValue(accessor).get();
    }

    public DataAccessor<?> getAccessorById(String id) {
        for (DataAccessor<?> dataAccessor : this.dataMap.keySet()) {
            if (!dataAccessor.key().equals(id)) continue;
            return dataAccessor;
        }
        return null;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        this.dataMap.values().forEach(e -> e.serialize(tag, false));
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.dataMap.values().forEach(e -> e.deserialize(tag, false));
    }

    public static class DataValue<T> {
        private final DataAccessor<T> accessor;
        private final boolean save;
        private final boolean synchronize;
        private final T initialValue;
        private T value;

        DataValue(DataAccessor<T> accessor, T value, boolean save, boolean synchronize) {
            this.accessor = accessor;
            this.initialValue = value;
            this.value = value;
            this.save = save;
            this.synchronize = synchronize;
        }

        public void set(T value) {
            this.value = value;
        }

        public void reset() {
            this.value = this.initialValue;
        }

        public boolean synchronizeWithOthers() {
            return this.synchronize;
        }

        public T get() {
            return this.value;
        }

        public T initial() {
            return this.initialValue;
        }

        public boolean saves() {
            return this.save;
        }

        public class_2487 serialize(class_2487 tag, boolean update) {
            return this.serialize(tag, this.value, update);
        }

        public class_2487 serialize(class_2487 tag, T value, boolean sync) {
            if (!this.save && !sync) {
                return tag;
            }
            tag.method_10566(this.accessor.key(), this.accessor.serializer().toTag().apply(value));
            return tag;
        }

        public void deserialize(class_2487 tag, boolean sync) {
            if (!this.save && !sync) {
                return;
            }
            this.set(this.accessor.serializer().fromTag().apply(tag, this.accessor.key()));
        }
    }
}

