/*
 * Decompiled with CFR 0.152.
 */
package cn.ksmcbrigade.ft;

import cn.ksmcbrigade.ft.FTTemp;
import cn.ksmcbrigade.ft.block.FakeBlock;
import cn.ksmcbrigade.ft.entity.FakeBlockEntity;
import cn.ksmcbrigade.ft.items.FakeItem;
import cn.ksmcbrigade.ft.items.FakeTechItem;
import cn.ksmcbrigade.ft.network.AddFakeBlockPacketMsg;
import cn.ksmcbrigade.ft.network.ClearFakeBlockPacketMsg;
import cn.ksmcbrigade.ft.types.FakeBlockEntityType;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DSL;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="ft")
public class FakeThings {
    public static final String MODID = "ft";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"ft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ft");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"ft");
    public static final RegistryObject<Block> FAKE_BLOCK = BLOCKS.register("fake_block", () -> new FakeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Item> FAKE_BLOCK_ITEM = ITEMS.register("fake_block", () -> new BlockItem((Block)FAKE_BLOCK.get(), new Item.Properties()){

        public void m_7373_(@NotNull ItemStack p_40572_, @Nullable Level p_40573_, @NotNull List<Component> p_40574_, @NotNull TooltipFlag p_40575_) {
            p_40574_.add((Component)Component.m_237113_((String)"DO NOT USE THIS BLOCK ITEM."));
        }
    });
    public static final RegistryObject<Item> FAKE_ITEM = ITEMS.register("fake_item", FakeItem::new);
    public static final RegistryObject<Item> FAKE_TECH_ITEM = ITEMS.register("fake_tech_item", FakeTechItem::new);
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"ft");
    public static final RegistryObject<FakeBlockEntityType> FAKE_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("fake_block_entity_type", () -> new FakeBlockEntityType((BlockEntityType.BlockEntitySupplier<? extends FakeBlockEntity>)((BlockEntityType.BlockEntitySupplier)FakeBlockEntity::new), Set.copyOf(ForgeRegistries.BLOCKS.getValues()), Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)"fake_block_entity_type")));
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.m_214293_((String)"ft", (String)"sync"), () -> "345", s -> true, s -> true);
    public static final RegistryObject<CreativeModeTab> FAKE_TAB = CREATIVE_MODE_TABS.register("fake_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)FAKE_ITEM.get()).m_7968_()).m_257501_((parameters, output) -> {
        output.m_246326_((ItemLike)FAKE_ITEM.get());
        output.m_246326_((ItemLike)FAKE_BLOCK_ITEM.get());
    }).m_257652_());

    public FakeThings() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        CHANNEL.registerMessage(0, AddFakeBlockPacketMsg.class, AddFakeBlockPacketMsg::encode, AddFakeBlockPacketMsg::decode, AddFakeBlockPacketMsg::handle);
        CHANNEL.registerMessage(1, ClearFakeBlockPacketMsg.class, ClearFakeBlockPacketMsg::encode, ClearFakeBlockPacketMsg::decode, ClearFakeBlockPacketMsg::handle);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        LOGGER.info("{} Mod Loaded.", (Object)FakeThings.class.getName());
    }

    @SubscribeEvent
    public void onMine(LivingDestroyBlockEvent event) {
        if (!event.isCanceled() && event.getState().m_60734_() instanceof FakeBlock) {
            CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AddFakeBlockPacketMsg(event.getPos(), event.getState().m_60734_(), true));
        }
    }

    @SubscribeEvent
    public void onMine(LivingUseTotemEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21120_(player.m_7655_()).m_41720_() instanceof FakeItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void load(LevelEvent.Load levelEvent) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClearFakeBlockPacketMsg());
    }

    @SubscribeEvent
    public void unload(LevelEvent.Unload levelEvent) {
        FTTemp.fakeBlocks.forEach((b, block) -> levelEvent.getLevel().m_7731_(b, Blocks.f_50016_.m_49966_(), 11));
        CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClearFakeBlockPacketMsg());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        FTTemp.fakeBlocks.forEach((b, block) -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new AddFakeBlockPacketMsg((BlockPos)b, (Block)block, false)));
    }

    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"give-fake").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)event.getBuildContext())).executes(context -> FakeThings.command((CommandContext<CommandSourceStack>)context, Collections.emptyList(), 1, 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> FakeThings.command((CommandContext<CommandSourceStack>)context, Collections.emptyList(), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"damage", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FakeThings.command((CommandContext<CommandSourceStack>)context, Collections.emptyList(), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), IntegerArgumentType.getInteger((CommandContext)context, (String)"damage")))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(context -> FakeThings.command((CommandContext<CommandSourceStack>)context, EntityArgument.m_91477_((CommandContext)context, (String)"players"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"), IntegerArgumentType.getInteger((CommandContext)context, (String)"damage"))))))));
    }

    private static int command(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> players, int count, int damage) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null && players.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Please use this command as a player."));
            return 1;
        }
        ItemStack fakeItem = new ItemStack((ItemLike)FAKE_ITEM.get());
        fakeItem.m_41784_().m_128359_("fake_item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ItemArgument.m_120963_(context, (String)"item").m_120979_())).toString());
        fakeItem.m_41784_().m_128405_("fake_damage", damage);
        if (players.isEmpty()) {
            for (int i = 1; i <= count; ++i) {
                ((CommandSourceStack)context.getSource()).m_81375_().m_36356_(fakeItem.m_41777_());
            }
        } else {
            for (ServerPlayer serverPlayer : players) {
                for (int i = 1; i <= count; ++i) {
                    serverPlayer.m_36356_(fakeItem.m_41777_());
                }
            }
        }
        return 0;
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(FAKE_BLOCK_ITEM);
        }
    }
}

