/*
 * Decompiled with CFR 0.152.
 */
package cn.ksmcbrigade.ft.network;

import cn.ksmcbrigade.ft.FTTemp;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record AddFakeBlockPacketMsg(BlockPos pos, Block block, boolean remove) {
    public static void encode(AddFakeBlockPacketMsg msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)msg.block)));
        buf.writeBoolean(msg.remove);
    }

    public static AddFakeBlockPacketMsg decode(FriendlyByteBuf buf) {
        return new AddFakeBlockPacketMsg(buf.m_130135_(), (Block)ForgeRegistries.BLOCKS.getValue(buf.m_130281_()), buf.readBoolean());
    }

    public static void handle(AddFakeBlockPacketMsg msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (!msg.remove) {
                FTTemp.fakeBlocks.put(msg.pos, msg.block);
            } else {
                FTTemp.fakeBlocks.remove(msg.pos);
            }
        }));
        if (!msg.remove) {
            FTTemp.fakeBlocks.put(msg.pos, msg.block);
        } else {
            FTTemp.fakeBlocks.remove(msg.pos);
        }
        ctx.get().setPacketHandled(true);
    }
}

