/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.calcinationoven;

import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class CalcinationStorageBehaviour
extends StorageBehaviour<CalcinationStorageBehaviour> {
    public ItemStackHandler inputInventory;
    public ItemStackHandler outputInventory;
    public PreventInsertWrapper outputInventoryExtractOnlyWrapper;
    public CombinedInvWrapper inventory;
    public Supplier<CalcinationCraftingBehaviour> craftingBehaviour;

    public CalcinationStorageBehaviour(BlockEntity blockEntity, Supplier<CalcinationCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.outputInventory = new OutputInventory();
        this.outputInventoryExtractOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryExtractOnlyWrapper});
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("inputInventory")) {
            this.inputInventory.deserializeNBT(pRegistries, pTag.getCompound("inputInventory"));
        }
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(pRegistries));
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            CalcinationStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            CalcinationStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return CalcinationStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            CalcinationStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            CalcinationStorageBehaviour.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            CalcinationStorageBehaviour.this.setChanged();
        }
    }
}

