/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.incubator;

import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorMercuryVesselBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSaltVesselBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.incubator.IncubatorSulfurVesselBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.crafting.HasCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.heat.HeatConsumerBehaviour;
import com.klikli_dev.theurgy.content.capability.CraftingHeatReceiver;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.IncubatorRecipeInput;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BlockEntity
implements HasCraftingBehaviour<IncubatorRecipeInput, IncubationRecipe, RecipeManager.CachedCheck<IncubatorRecipeInput, IncubationRecipe>> {
    public IncubatorMercuryVesselBlockEntity mercuryVessel;
    public IncubatorSulfurVesselBlockEntity sulfurVessel;
    public IncubatorSaltVesselBlockEntity saltVessel;
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public IncubatorRecipeInput ItemHandlerRecipeInput;
    public CraftingHeatReceiver heatReceiver = new CraftingHeatReceiver(this);
    public boolean isValidMultiblock;
    protected IncubatorCraftingBehaviour craftingBehaviour = new IncubatorCraftingBehaviour(this, () -> this.ItemHandlerRecipeInput, () -> null, () -> this.outputInventory);
    protected HeatConsumerBehaviour heatConsumerBehaviour = new HeatConsumerBehaviour(this);
    protected boolean checkValidMultiblockOnNextQuery = true;

    public IncubatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.INCUBATOR.get(), pPos, pBlockState);
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
        this.craftingBehaviour.readNetwork(pTag, pRegistries);
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
        this.craftingBehaviour.writeNetwork(pTag, pRegistries);
    }

    public void tickServer() {
        boolean isHeated = this.heatConsumerBehaviour.isHeated();
        boolean hasInput = this.isValidMultiblock() && !this.mercuryVessel.inputInventory.getStackInSlot(0).isEmpty() && !this.saltVessel.inputInventory.getStackInSlot(0).isEmpty() && !this.sulfurVessel.inputInventory.getStackInSlot(0).isEmpty();
        this.craftingBehaviour.tickServer(isHeated, hasInput);
    }

    public void tickClient() {
        RandomSource random;
        boolean isProcessing = this.craftingBehaviour.isProcessing();
        if (isProcessing && (random = this.getLevel().getRandom()).nextFloat() < 0.11f) {
            for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                this.getLevel().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)this.getBlockPos().getX() + 0.5 + (double)random.nextFloat() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)((float)(this.getBlockPos().getY() + 2) + random.nextFloat()), (double)this.getBlockPos().getZ() + 0.5 + (double)random.nextFloat() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
            }
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("heatReceiver", this.heatReceiver.serializeNBT(pRegistries));
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("heatReceiver")) {
            this.heatReceiver.deserializeNBT(pRegistries, pTag.get("heatReceiver"));
        }
        this.readNetwork(pTag, pRegistries);
    }

    private void checkForVessel(BlockPos pos) {
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        if (blockEntity instanceof IncubatorMercuryVesselBlockEntity) {
            IncubatorMercuryVesselBlockEntity mercury;
            this.mercuryVessel = mercury = (IncubatorMercuryVesselBlockEntity)blockEntity;
            mercury.setIncubator(this);
        } else if (blockEntity instanceof IncubatorSulfurVesselBlockEntity) {
            IncubatorSulfurVesselBlockEntity sulfur;
            this.sulfurVessel = sulfur = (IncubatorSulfurVesselBlockEntity)blockEntity;
            sulfur.setIncubator(this);
        } else if (blockEntity instanceof IncubatorSaltVesselBlockEntity) {
            IncubatorSaltVesselBlockEntity salt;
            this.saltVessel = salt = (IncubatorSaltVesselBlockEntity)blockEntity;
            salt.setIncubator(this);
        }
    }

    public void validateMultiblock() {
        IncubatorMercuryVesselBlockEntity oldMercuryVessel = this.mercuryVessel;
        IncubatorSaltVesselBlockEntity oldSaltVessel = this.saltVessel;
        IncubatorSulfurVesselBlockEntity oldSulfurVessel = this.sulfurVessel;
        boolean wasValidMultiblock = this.isValidMultiblock;
        this.mercuryVessel = null;
        this.saltVessel = null;
        this.sulfurVessel = null;
        Direction.Plane.HORIZONTAL.stream().forEach(direction -> {
            BlockPos pos = this.getBlockPos().relative(direction);
            this.checkForVessel(pos);
        });
        boolean bl = this.isValidMultiblock = this.mercuryVessel != null && this.sulfurVessel != null && this.saltVessel != null;
        if (wasValidMultiblock != this.isValidMultiblock) {
            if (this.isValidMultiblock) {
                this.onAssembleMultiblock();
            } else {
                this.onDisassembleMultiblock();
            }
        }
        if (oldMercuryVessel != this.mercuryVessel || oldSaltVessel != this.saltVessel || oldSulfurVessel != this.sulfurVessel) {
            this.craftingBehaviour.onInputItemChanged(ItemStack.EMPTY, ItemStack.EMPTY);
        }
    }

    public void onAssembleMultiblock() {
        this.ItemHandlerRecipeInput = new IncubatorRecipeInput((IItemHandlerModifiable)this.mercuryVessel.inputInventory, (IItemHandlerModifiable)this.saltVessel.inputInventory, (IItemHandlerModifiable)this.sulfurVessel.inputInventory);
    }

    public void onDisassembleMultiblock() {
        this.ItemHandlerRecipeInput = null;
    }

    public void setRemoved() {
        if (this.mercuryVessel != null) {
            this.mercuryVessel.setIncubator(null);
            this.mercuryVessel = null;
        }
        if (this.sulfurVessel != null) {
            this.sulfurVessel.setIncubator(null);
            this.sulfurVessel = null;
        }
        if (this.saltVessel != null) {
            this.saltVessel.setIncubator(null);
            this.saltVessel = null;
        }
        super.setRemoved();
    }

    public boolean isValidMultiblock() {
        if (this.checkValidMultiblockOnNextQuery) {
            this.checkValidMultiblockOnNextQuery = false;
            this.validateMultiblock();
        }
        return this.isValidMultiblock;
    }

    public IncubatorCraftingBehaviour craftingBehaviour() {
        return this.craftingBehaviour;
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            IncubatorBlockEntity.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            IncubatorBlockEntity.this.setChanged();
        }
    }
}

