/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.crafting;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public abstract class CraftingBehaviour<W extends RecipeInput, R extends Recipe<W>, C extends RecipeManager.CachedCheck<W, R>> {
    protected BlockEntity blockEntity;
    protected Supplier<W> recipeInputSupplier;
    protected Supplier<IItemHandlerModifiable> inputInventorySupplier;
    protected Supplier<IItemHandlerModifiable> outputInventorySupplier;
    protected C recipeCachedCheck;
    protected int progress;
    protected int totalTime;
    protected boolean isProcessing;
    protected boolean couldCraftLastTick;

    public CraftingBehaviour(BlockEntity blockEntity, Supplier<W> recipeInputSupplier, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, C recipeCachedCheck) {
        this.blockEntity = blockEntity;
        this.recipeInputSupplier = recipeInputSupplier;
        this.inputInventorySupplier = inputInventorySupplier;
        this.outputInventorySupplier = outputInventorySupplier;
        this.recipeCachedCheck = recipeCachedCheck;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public boolean couldCraftLastTick() {
        return this.couldCraftLastTick;
    }

    public void readNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.isProcessing = tag.getBoolean("isProcessing");
    }

    public void writeNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.putBoolean("isProcessing", this.isProcessing);
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putShort("progress", (short)this.progress);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("progress")) {
            this.progress = pTag.getShort("progress");
        }
    }

    public void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
    }

    public void collectImplicitComponents(DataComponentMap.Builder pComponents) {
    }

    public Optional<RecipeHolder<R>> getRecipe() {
        return this.recipeCachedCheck.getRecipeFor((RecipeInput)this.recipeInputSupplier.get(), this.blockEntity.getLevel());
    }

    public void tickServer(boolean canProcess, boolean hasInput) {
        if (hasInput) {
            RecipeHolder recipe = this.getRecipe().orElse(null);
            this.couldCraftLastTick = this.canCraft(recipe);
            if (canProcess && this.couldCraftLastTick) {
                this.tryStartProcessing();
                ++this.progress;
                this.tryFinishProcessing(recipe);
            } else {
                this.stopProcessing();
            }
        } else {
            this.stopProcessing();
        }
    }

    public void onInputItemChanged(ItemStack oldStack, ItemStack newStack) {
        this.totalTime = this.getTotalTime();
        this.progress = 0;
    }

    public boolean canProcess(ItemStack stack) {
        if (this.alreadyHasInput(stack)) {
            return true;
        }
        return this.isIngredient(stack);
    }

    public abstract boolean isIngredient(ItemStack var1);

    public boolean canProcess(FluidStack stack) {
        return false;
    }

    public boolean isIngredient(FluidStack stack) {
        return false;
    }

    protected boolean alreadyHasInput(ItemStack stack) {
        return IntStream.range(0, this.inputInventorySupplier.get().getSlots()).anyMatch(i -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.inputInventorySupplier.get().getStackInSlot(i)));
    }

    protected void tryFinishProcessing(RecipeHolder<R> pRecipe) {
        if (this.progress >= this.totalTime) {
            this.progress = 0;
            this.totalTime = this.getTotalTime();
            this.craft(pRecipe);
            this.sendBlockUpdated();
        }
    }

    protected void tryStartProcessing() {
        if (this.progress == 0) {
            this.isProcessing = true;
            this.sendBlockUpdated();
        }
    }

    public void stopProcessing() {
        if (this.progress != 0 || this.isProcessing) {
            this.isProcessing = false;
            this.couldCraftLastTick = false;
            this.progress = 0;
            this.sendBlockUpdated();
        }
    }

    public boolean canCraft(@Nullable RecipeHolder<R> pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        ItemStack assembledStack = pRecipe.value().assemble((RecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        if (assembledStack.isEmpty()) {
            return false;
        }
        ItemStack remainingStack = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)true);
        return remainingStack.isEmpty();
    }

    protected boolean craft(RecipeHolder<R> pRecipe) {
        ItemStack assembledStack = pRecipe.value().assemble((RecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        this.inputInventorySupplier.get().extractItem(0, this.getIngredientCount(pRecipe), false);
        return true;
    }

    protected int getTotalTime() {
        return this.recipeCachedCheck.getRecipeFor((RecipeInput)this.recipeInputSupplier.get(), this.blockEntity.getLevel()).map(this::getCraftingTime).orElse(this.getDefaultCraftingTime());
    }

    protected void sendBlockUpdated() {
        if (this.blockEntity.getLevel() != null && !this.blockEntity.getLevel().isClientSide) {
            this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 2);
        }
    }

    protected abstract int getIngredientCount(RecipeHolder<R> var1);

    protected abstract int getCraftingTime(RecipeHolder<R> var1);

    protected abstract int getDefaultCraftingTime();
}

