/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.heat;

import com.klikli_dev.theurgy.content.capability.HeatProvider;
import com.klikli_dev.theurgy.content.capability.HeatReceiver;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HeatConsumerBehaviour {
    private final BlockEntity blockEntity;
    int CHECK_HEAT_TICK_INTERVAL = 20;
    private boolean heatedCache;

    public HeatConsumerBehaviour(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    boolean hasHeatProvider() {
        HeatProvider heatBelow = (HeatProvider)this.blockEntity.getLevel().getCapability(CapabilityRegistry.HEAT_PROVIDER, this.blockEntity.getBlockPos().below(), (Object)Direction.UP);
        if (heatBelow != null) {
            return heatBelow.isHot();
        }
        return false;
    }

    public boolean isHeated() {
        if (this.blockEntity.getLevel().getGameTime() % (long)this.CHECK_HEAT_TICK_INTERVAL == 0L) {
            HeatReceiver heatReceiver;
            boolean wasHeated = this.heatedCache;
            boolean isHeated = this.hasHeatProvider();
            if (!isHeated && (heatReceiver = (HeatReceiver)this.blockEntity.getLevel().getCapability(CapabilityRegistry.HEAT_RECEIVER, this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity, null)) != null) {
                isHeated = heatReceiver.getIsHotUntil() > this.blockEntity.getLevel().getGameTime();
            }
            this.heatedCache = isHeated;
            if (wasHeated != isHeated) {
                if (this.blockEntity.getBlockState().hasProperty((Property)BlockStateProperties.LIT)) {
                    BlockState newState = (BlockState)this.blockEntity.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isHeated));
                    this.blockEntity.getLevel().setBlock(this.blockEntity.getBlockPos(), newState, 3);
                }
                this.blockEntity.setChanged();
            }
        }
        return this.heatedCache;
    }
}

