/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.itemhandler;

import com.klikli_dev.theurgy.content.behaviour.itemhandler.ItemHandlerBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class DynamicOneOutputSlotItemHandlerBehaviour
implements ItemHandlerBehaviour {
    protected int getOutputSlot(IItemHandler handler) {
        return handler.getSlots() - 1;
    }

    protected int getMaxInputSlot(IItemHandler handler) {
        return handler.getSlots() - 2;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IItemHandler blockItemHandler = (IItemHandler)pLevel.getCapability(Capabilities.ItemHandler.BLOCK, pPos, null);
        if (blockItemHandler == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int outputSlot = this.getOutputSlot(blockItemHandler);
        int maxInputSlot = this.getMaxInputSlot(blockItemHandler);
        ItemStack stackInHand = pPlayer.getItemInHand(pHand);
        if (stackInHand.isEmpty()) {
            ItemStack extracted = blockItemHandler.extractItem(outputSlot, blockItemHandler.getSlotLimit(outputSlot), false);
            if (!extracted.isEmpty()) {
                pPlayer.getInventory().placeItemBackInInventory(extracted);
                return ItemInteractionResult.SUCCESS;
            }
            for (int inputSlot = 0; inputSlot <= maxInputSlot; ++inputSlot) {
                extracted = blockItemHandler.extractItem(inputSlot, blockItemHandler.getSlotLimit(inputSlot), false);
                if (extracted.isEmpty()) continue;
                pPlayer.getInventory().placeItemBackInInventory(extracted);
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            for (int inputSlot = 0; inputSlot <= maxInputSlot; ++inputSlot) {
                ItemStack remainder = blockItemHandler.insertItem(inputSlot, stackInHand, false);
                pPlayer.setItemInHand(pHand, remainder);
                if (remainder.getCount() == stackInHand.getCount()) continue;
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

