/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.redstone;

import com.klikli_dev.theurgy.content.behaviour.BlockEntityBehaviour;
import com.klikli_dev.theurgy.content.behaviour.crafting.HasCraftingBehaviour;
import com.klikli_dev.theurgy.util.RedstoneUtil;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class VatRedstoneAutoCloseBehaviour<R extends Recipe<?>>
extends BlockEntityBehaviour {
    protected int randomSlowTickOffset = (int)(Math.random() * 20.0);
    protected HasCraftingBehaviour<?, R, ?> hasCraftingBehaviour;

    public VatRedstoneAutoCloseBehaviour(BlockEntity blockEntity) {
        super(blockEntity);
        if (!(blockEntity instanceof HasCraftingBehaviour)) {
            throw new IllegalArgumentException("Block entity must implement HasCraftingBehaviour");
        }
        this.hasCraftingBehaviour = (HasCraftingBehaviour)blockEntity;
    }

    public void tickServer() {
        if ((this.level().getGameTime() + (long)this.randomSlowTickOffset) % 20L == 0L) {
            this.tryAutoClose();
        }
    }

    protected void tryAutoClose() {
        Optional<RecipeHolder<R>> recipe;
        boolean hasSignal = RedstoneUtil.hasNeighborSignal(this.level(), this.getBlockPos(), ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
        boolean wasOpen = (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.OPEN);
        if (hasSignal && wasOpen && (recipe = this.hasCraftingBehaviour.craftingBehaviour().getRecipe()).isPresent() && this.hasCraftingBehaviour.craftingBehaviour().canCraft(recipe.get())) {
            this.level().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)), 2);
        }
    }
}

