/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.entity;

import com.klikli_dev.theurgy.content.particle.ParticleColor;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ColoredProjectile
extends Projectile {
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> FINAL_COLOR = SynchedEntityData.defineId(ColoredProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn);
        this.setPos(x, y, z);
    }

    public ColoredProjectile(EntityType<? extends ColoredProjectile> type, Level worldIn, LivingEntity shooter) {
        super(type, worldIn);
        this.setOwner((Entity)shooter);
    }

    public void color(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public void finalColor(int color) {
        this.entityData.set(FINAL_COLOR, (Object)color);
    }

    public int color() {
        return (Integer)this.entityData.get(COLOR);
    }

    public int finalColor() {
        return (Integer)this.entityData.get(FINAL_COLOR);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.entityData.set(COLOR, (Object)compound.getInt("color"));
        this.entityData.set(FINAL_COLOR, (Object)compound.getInt("final_color"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("color", ((Integer)this.entityData.get(COLOR)).intValue());
        compound.putInt("final_color", ((Integer)this.entityData.get(FINAL_COLOR)).intValue());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR, (Object)new ParticleColor(255, 25, 180).getColor());
        builder.define(FINAL_COLOR, (Object)new ParticleColor(255, 25, 180).getColor());
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }
}

