/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ReformationArrayEntry
extends EntryProvider {
    public static final String ENTRY_ID = "reformation_array";

    public ReformationArrayEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Reformation Array");
        this.pageText("Reformation is performed in a so-called \"Reformation Array\", a complex combination of apparatus that guide Sulfuric Flux to transform Sulfur.\n\\\n\\\nView the {0} Category on how to craft and use the required apparatus.\n", new Object[]{this.entryLink("Apparatus", "apparatus", ENTRY_ID)});
        this.page("target", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.REFORMATION_TARGET_PEDESTAL.get()})).withText(this.context().pageText()));
        this.pageText("You need one target pedestal, which will hold the sulfur you want to create more of.\n");
        this.page("result", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()})).withText(this.context().pageText()));
        this.pageText("Further, you need one result pedestal, in which the output sulfur will end up.\n");
        this.page("source", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.REFORMATION_SOURCE_PEDESTAL.get()})).withText(this.context().pageText()));
        this.pageText("Then you need at least one source pedestal, which will hold the sulfur that will be consumed to be converted.\n\\\n\\\nIt is recommended to have at least 2 or more such pedestals, as some future recipes require more than one sulfur to be consumed.\n");
        this.page("emitter", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()})).withText(this.context().pageText()));
        this.pageText("Finally, you need a sulfuric flux emitter that will drive the actual conversion.\n");
        this.page("next_steps", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Next Steps");
        this.pageText("Craft all the apparatus and place and link them as described in {0}.\\\nAfter, [#]($INPUT)right-click[#]() the {1} with an empty hand to see if it is linked to all the pedestals.\n\\\n\\\nThen move on to the next entry.\n", new Object[]{this.entryLink("Reformation Array", "apparatus", ENTRY_ID), this.itemLink((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get())});
    }

    protected String entryName() {
        return "Required Apparatus";
    }

    protected String entryDescription() {
        return "The apparatus needed for reformation";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.REFORMATION_RESULT_PEDESTAL.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

