/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.NiterRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FermentationEntry
extends EntryProvider {
    public static final String ENTRY_ID = "fermentation_transmutation";

    public FermentationEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Fermentation");
        this.pageText("We need two different Niters: some {0} as source that we want to convert and at least one {1} as conversion target.\n", new Object[]{this.itemLink("Alchemical Niter: Common Gems", (ItemLike)NiterRegistry.GEMS_COMMON.get()), this.itemLink("Alchemical Niter: Common Metals", (ItemLike)NiterRegistry.METALS_COMMON.get())});
        this.page("gems", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NiterRegistry.GEMS_COMMON.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Alchemical Niter: Common Gems");
        this.pageText("[#]($INPUT)Right-click[#]() the {0} with the ingredients to place them inside:\n- {1}\n- {2}\n- {3} or any Crops, or better: {4}\n\n(Check JEI/EMI for more recipes)\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.FERMENTATION_VAT.get()), this.itemLink("Alchemical Sulfur: Quartz", (ItemLike)SulfurRegistry.QUARTZ.get()), this.itemLink((ItemLike)Items.WATER_BUCKET), this.itemLink((ItemLike)Items.SUGAR), this.itemLink((ItemLike)ItemRegistry.FERMENTATION_STARTER)});
        this.page("metals", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)NiterRegistry.METALS_COMMON.get()})).withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Alchemical Niter: Common Metals");
        this.pageText("[#]($INPUT)Right-click[#]() the {0} with the ingredients to place them inside:\n- {1}\n- {2}\n- {3} or any Crops\n\n(Check JEI for more recipes)\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.FERMENTATION_VAT.get()), this.itemLink("Alchemical Sulfur: Iron", (ItemLike)SulfurRegistry.IRON.get()), this.itemLink((ItemLike)Items.WATER_BUCKET), this.itemLink((ItemLike)Items.SUGAR)});
        this.page("start", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Process");
        this.pageText("[#]($INPUT)Shift-right-click[#]() the {0} with an [#]($INPUT)empty hand[#]() to close the vat and start the fermentation.\n\\\n\\\nOnce it opens again the process is complete.\n\\\n\\\n[#]($INPUT)Right-click[#]() with an empty hand to retrieve the {1}.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.FERMENTATION_VAT.get()), this.itemLink("Alchemical Niter: Common Gems", (ItemLike)NiterRegistry.GEMS_COMMON.get())});
        this.page("bulk", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Bulk Processing");
        this.pageText("You can provide all these ingredients in bulk, the process will then repeat until all ingredients are consumed.\n\\\n\\\nYou can also [#]($INPUT)shift-right-click[#]() with an [#]($INPUT)empty hand[#]() to open the vat and interrupt processing to take out the intermediate result.\n");
        this.page("bulk2", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Bulk Processing");
        this.pageText("Remember: the more Niter you produce from Quartz (via Quartz Sulfur) the more Iron you can get in the end.\n");
    }

    protected String entryName() {
        return "Fermentation";
    }

    protected String entryDescription() {
        return "Convert Quartz Sulfur into Common Gems Niter";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)NiterRegistry.GEMS_COMMON.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

