/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.logistics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MercurialWandEntry
extends EntryProvider {
    public static final String ENTRY_ID = "mercurial_wand";

    public MercurialWandEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("conversion", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.MERCURIAL_WAND.get()})).withText(this.context().pageText()));
        this.pageText("Mercurial Logistics apparatus can be controlled and configured using the Mercurial Wand.\n");
        this.page("recipe", () -> (BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(Theurgy.loc("crafting/shaped/mercurial_wand")));
        this.page("usage", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Usage");
        this.pageText("Crouch and Scroll to change the mode of the wand.\n\\\n\\\nRight-click to interact with the target apparatus/block.\n");
        this.page("rotate", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Cycle Selected Direction");
        this.pageText("With this mode, right-clicking on a block will cycle the selected direction of the target block.\n\\\n\\\nThe \"selected direction\" is the direction the block will insert/extract to/from.\n\\\n\\\nThe default selected direction is the face the block is attached to.\n");
        this.page("rotate_visuals", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Cycle Selected Direction");
        this.pageText("When looking at a logistics block with this mode selected, the block will highlight the selected direction on its target block.\n\\\n\\\nYellow is the current direction, green is the direction that will be set if you right-click.\\\nMake sure that the side you want to insert/extract from is yellow!\n");
        this.page("enable", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Enable/Disable");
        this.pageText("With this mode, right-clicking on a block will enable or disable it.\n\\\n\\\nA disabled block will no longer insert or extract from the block it is attached to.\n");
    }

    protected String entryName() {
        return "Mercurial Wand";
    }

    protected String entryDescription() {
        return "Controlling Mercurial Logistics";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.MERCURIAL_WAND.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

