/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.integration.emi.EmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class AccumulationEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<AccumulationRecipe> recipe;

    public AccumulationEmiRecipe(RecipeHolder<AccumulationRecipe> recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.ACCUMULATION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        if (((AccumulationRecipe)this.recipe.value()).hasSolute()) {
            inputs.add(EmiIngredient.of((Ingredient)((AccumulationRecipe)this.recipe.value()).getSolute()));
        }
        if (((AccumulationRecipe)this.recipe.value()).hasEvaporant()) {
            inputs.add(EmiIngredient.of(Arrays.stream(((AccumulationRecipe)this.recipe.value()).getEvaporant().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)f.getAmount())).toList()));
        }
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((Fluid)((AccumulationRecipe)this.recipe.value()).getResult().getFluid(), (long)((AccumulationRecipe)this.recipe.value()).getResult().getAmount()));
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 40;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 24, 2);
        if (((AccumulationRecipe)this.recipe.value()).hasEvaporant()) {
            widgets.addSlot(EmiIngredient.of(Arrays.stream(((AccumulationRecipe)this.recipe.value()).getEvaporant().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)f.getAmount())).toList()), 1, 1);
        }
        if (((AccumulationRecipe)this.recipe.value()).hasSolute()) {
            widgets.addSlot(EmiIngredient.of((Ingredient)((AccumulationRecipe)this.recipe.value()).getSolute()), 1, 21);
        }
        widgets.addSlot((EmiIngredient)EmiStack.of((Fluid)((AccumulationRecipe)this.recipe.value()).getResult().getFluid(), (long)((AccumulationRecipe)this.recipe.value()).getResult().getAmount()), 56, 1).recipeContext((EmiRecipe)this);
        int cookTime = ((AccumulationRecipe)this.recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            widgets.addText((Component)timeString, this.getDisplayWidth() - stringWidth, 29, -8355712, false);
        }
    }
}

