/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.logistics;

import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record WireEndPoint(BlockPos pos, ResourceKey<Level> level) {
    public static final Codec<WireEndPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(r -> r.pos), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("level").forGetter(r -> r.level)).apply((Applicative)instance, WireEndPoint::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WireEndPoint> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WireEndPoint::pos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), WireEndPoint::level, WireEndPoint::new);

    public static WireEndPoint load(CompoundTag tag) {
        return new WireEndPoint(BlockPos.of((long)tag.getLong("pos")), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("level"))));
    }

    @Nullable
    public static WireEndPoint load(ItemStack stack) {
        return (WireEndPoint)stack.get((DataComponentType)DataComponentRegistry.WIRE_END_POINT.get());
    }

    public static void removeFrom(ItemStack stack) {
        stack.remove((DataComponentType)DataComponentRegistry.WIRE_END_POINT.get());
    }

    public void save(ItemStack stack) {
        stack.set((DataComponentType)DataComponentRegistry.WIRE_END_POINT.get(), (Object)this);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putLong("pos", this.pos.asLong());
        tag.putString("level", this.level.location().toString());
        return tag;
    }
}

