/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.item.divinationrod.DivinationRodItem;
import com.klikli_dev.theurgy.network.Message;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MessageSetDivinationResult
implements Message {
    public static final CustomPacketPayload.Type<MessageSetDivinationResult> TYPE = new CustomPacketPayload.Type(Theurgy.loc("set_divination_result"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetDivinationResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), m -> Optional.ofNullable(m.pos), (StreamCodec)ByteBufCodecs.BYTE, m -> m.distance, (pos, distance) -> new MessageSetDivinationResult(pos.orElse(null), distance.byteValue()));
    public final BlockPos pos;
    public final byte distance;

    public MessageSetDivinationResult(BlockPos pos, float distance) {
        this.pos = pos;
        this.distance = (byte)Math.min(256.0f, distance);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof DivinationRodItem) {
            stack.set((DataComponentType)DataComponentRegistry.DIVINATION_DISTANCE.get(), (Object)Float.valueOf(this.distance));
            stack.set((DataComponentType)DataComponentRegistry.DIVINATION_POS.get(), (Object)this.pos);
            player.inventoryMenu.broadcastChanges();
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

