/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.niter.AlchemicalNiterItem;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NiterRegistry {
    public static final DeferredRegister.Items NITERS = DeferredRegister.createItems((String)"theurgy");
    public static final DeferredItem<AlchemicalNiterItem> EARTHEN_MATTERS_ABUNDANT = NiterRegistry.register("earthen_matters_abundant", Items.DIRT, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> EARTHEN_MATTERS_COMMON = NiterRegistry.register("earthen_matters_common", Items.CLAY_BALL, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> GEMS_ABUNDANT = NiterRegistry.register("gems_abundant", ItemRegistry.GEMS_ABUNDANT_ICON, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> GEMS_COMMON = NiterRegistry.register("gems_common", ItemRegistry.GEMS_COMMON_ICON, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> GEMS_RARE = NiterRegistry.register("gems_rare", ItemRegistry.GEMS_RARE_ICON, AlchemicalDerivativeTier.RARE);
    public static final DeferredItem<AlchemicalNiterItem> GEMS_PRECIOUS = NiterRegistry.register("gems_precious", ItemRegistry.GEMS_PRECIOUS_ICON, AlchemicalDerivativeTier.PRECIOUS);
    public static final DeferredItem<AlchemicalNiterItem> METALS_ABUNDANT = NiterRegistry.register("metals_abundant", ItemRegistry.METALS_ABUNDANT_ICON, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> METALS_COMMON = NiterRegistry.register("metals_common", ItemRegistry.METALS_COMMON_ICON, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> METALS_RARE = NiterRegistry.register("metals_rare", ItemRegistry.METALS_RARE_ICON, AlchemicalDerivativeTier.RARE);
    public static final DeferredItem<AlchemicalNiterItem> METALS_PRECIOUS = NiterRegistry.register("metals_precious", ItemRegistry.METALS_PRECIOUS_ICON, AlchemicalDerivativeTier.PRECIOUS);
    public static final DeferredItem<AlchemicalNiterItem> OTHER_MINERALS_ABUNDANT = NiterRegistry.register("other_minerals_abundant", ItemRegistry.OTHER_MINERALS_ABUNDANT_ICON, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> OTHER_MINERALS_COMMON = NiterRegistry.register("other_minerals_common", ItemRegistry.OTHER_MINERALS_COMMON_ICON, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> OTHER_MINERALS_RARE = NiterRegistry.register("other_minerals_rare", ItemRegistry.OTHER_MINERALS_RARE_ICON, AlchemicalDerivativeTier.RARE);
    public static final DeferredItem<AlchemicalNiterItem> OTHER_MINERALS_PRECIOUS = NiterRegistry.register("other_minerals_precious", ItemRegistry.OTHER_MINERALS_PRECIOUS_ICON, AlchemicalDerivativeTier.PRECIOUS);
    public static final DeferredItem<AlchemicalNiterItem> LOGS_ABUNDANT = NiterRegistry.register("logs_abundant", Items.OAK_LOG, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> CROPS_ABUNDANT = NiterRegistry.register("crops_abundant", Items.WHEAT, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> ANIMALS_ABUNDANT = NiterRegistry.register("animals_abundant", Items.BEEF, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> ANIMALS_COMMON = NiterRegistry.register("animals_common", Items.LEATHER, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> ANIMALS_RARE = NiterRegistry.register("animals_rare", Items.RABBIT_FOOT, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> MOBS_ABUNDANT = NiterRegistry.register("mobs_abundant", Items.ROTTEN_FLESH, AlchemicalDerivativeTier.ABUNDANT);
    public static final DeferredItem<AlchemicalNiterItem> MOBS_COMMON = NiterRegistry.register("mobs_commond", Items.BLAZE_ROD, AlchemicalDerivativeTier.COMMON);
    public static final DeferredItem<AlchemicalNiterItem> MOBS_RARE = NiterRegistry.register("mobs_rare", Items.GHAST_TEAR, AlchemicalDerivativeTier.RARE);
    public static final DeferredItem<AlchemicalNiterItem> MOBS_PRECIOUS = NiterRegistry.register("mobs_precious", Items.NETHER_STAR, AlchemicalDerivativeTier.PRECIOUS);

    public static DeferredItem<AlchemicalNiterItem> register(String name, TagKey<Item> source, AlchemicalDerivativeTier tier) {
        return NiterRegistry.register(name, () -> new AlchemicalNiterItem(new Item.Properties().component(DataComponentRegistry.SOURCE_TAG, (Object)source), tier));
    }

    public static DeferredItem<AlchemicalNiterItem> register(String name, DeferredItem<?> source, AlchemicalDerivativeTier tier) {
        return NiterRegistry.register(name, () -> new AlchemicalNiterItem(new Item.Properties().component(DataComponentRegistry.SOURCE_ITEM, (Object)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)source.getId())), tier));
    }

    public static DeferredItem<AlchemicalNiterItem> register(String name, Item source, AlchemicalDerivativeTier tier) {
        return NiterRegistry.register(name, () -> new AlchemicalNiterItem(new Item.Properties().component(DataComponentRegistry.SOURCE_ITEM, (Object)source.builtInRegistryHolder()), tier));
    }

    public static <T extends Item> DeferredItem<T> register(String name, Supplier<T> sup) {
        return NITERS.register("alchemical_niter_" + name, sup);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            NITERS.getEntries().forEach(n -> event.accept((ItemLike)n.get()));
        }
    }
}

