/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.distiller;

import com.klikli_dev.theurgy.content.recipe.DistillationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerRecipeInput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

class DistillationCachedCheck
implements RecipeManager.CachedCheck<ItemHandlerRecipeInput, DistillationRecipe> {
    private final RecipeType<DistillationRecipe> type;
    private final RecipeManager.CachedCheck<ItemHandlerRecipeInput, DistillationRecipe> internal;
    @Nullable
    private ResourceLocation lastRecipe;

    public DistillationCachedCheck(RecipeType<DistillationRecipe> type) {
        this.type = type;
        this.internal = RecipeManager.createCheck(type);
    }

    private Optional<RecipeHolder<DistillationRecipe>> getRecipeFor(ItemStack stack, Level level, @Nullable ResourceLocation lastRecipe) {
        RecipeHolder recipe;
        RecipeManager recipeManager = level.getRecipeManager();
        if (lastRecipe != null && (recipe = recipeManager.byKeyTyped(this.type, lastRecipe)) != null && ((DistillationRecipe)recipe.value()).getIngredient().ingredient().test(stack)) {
            return Optional.of(recipe);
        }
        return recipeManager.byType(this.type).stream().filter(entry -> ((DistillationRecipe)entry.value()).getIngredient().test(stack)).findFirst();
    }

    public Optional<RecipeHolder<DistillationRecipe>> getRecipeFor(ItemStack stack, Level level) {
        Optional<RecipeHolder<DistillationRecipe>> optional = this.getRecipeFor(stack, level, this.lastRecipe);
        if (optional.isPresent()) {
            RecipeHolder<DistillationRecipe> recipeHolder = optional.get();
            this.lastRecipe = recipeHolder.id();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<RecipeHolder<DistillationRecipe>> getRecipeFor(ItemHandlerRecipeInput container, Level level) {
        Optional recipe = this.internal.getRecipeFor((RecipeInput)container, level);
        if (recipe.isPresent()) {
            this.lastRecipe = ((RecipeHolder)recipe.get()).id();
        }
        return recipe;
    }
}

