/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron;

import com.klikli_dev.theurgy.content.apparatus.liquefactioncauldron.LiquefactionCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.storage.StorageBehaviour;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import com.klikli_dev.theurgy.registry.FluidTagRegistry;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class LiquefactionStorageBehaviour
extends StorageBehaviour<LiquefactionStorageBehaviour> {
    public ItemStackHandler inputInventory;
    public ItemStackHandler outputInventory;
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper;
    public CombinedInvWrapper inventory;
    public FluidTank solventTank;
    public Supplier<LiquefactionCraftingBehaviour> craftingBehaviour;

    public LiquefactionStorageBehaviour(BlockEntity blockEntity, Supplier<LiquefactionCraftingBehaviour> craftingBehaviour) {
        super(blockEntity);
        this.craftingBehaviour = craftingBehaviour;
        this.inputInventory = new InputInventory();
        this.outputInventory = new OutputInventory();
        this.outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
        this.inventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventoryTakeOnlyWrapper});
        this.solventTank = new SolventTank(2000, fluidStack -> fluidStack.getFluid().is(FluidTagRegistry.SOLVENT));
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("inputInventory")) {
            this.inputInventory.deserializeNBT(pRegistries, pTag.getCompound("inputInventory"));
        }
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
        if (pTag.contains("solventTank")) {
            this.solventTank.readFromNBT(pRegistries, pTag.getCompound("solventTank"));
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inputInventory", (Tag)this.inputInventory.serializeNBT(pRegistries));
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
        pTag.put("solventTank", (Tag)this.solventTank.writeToNBT(pRegistries, new CompoundTag()));
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.writeNetwork(pTag, pRegistries);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.readNetwork(pTag, pRegistries);
    }

    public class InputInventory
    extends MonitoredItemStackHandler {
        public InputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            LiquefactionStorageBehaviour.this.craftingBehaviour.get().onInputItemChanged(oldStack, newStack);
            LiquefactionStorageBehaviour.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return LiquefactionStorageBehaviour.this.craftingBehaviour.get().canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            LiquefactionStorageBehaviour.this.setChanged();
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            LiquefactionStorageBehaviour.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            LiquefactionStorageBehaviour.this.setChanged();
        }
    }

    public class SolventTank
    extends FluidTank {
        public SolventTank(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        protected void onContentsChanged() {
            LiquefactionStorageBehaviour.this.setChanged();
            LiquefactionStorageBehaviour.this.sendBlockUpdated();
        }
    }
}

