/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.ItemHandlerBehaviour;
import com.klikli_dev.theurgy.content.behaviour.itemhandler.OneSlotItemHandlerBehaviour;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    protected ItemHandlerBehaviour itemHandlerBehaviour = new OneSlotItemHandlerBehaviour();

    public MercuryCatalystBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public static int getBlockColor(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos, int pTintIndex) {
        BlockEntity blockEntity;
        if (pTintIndex != 0 && pLevel != null && pPos != null && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof MercuryCatalystBlockEntity) {
            MercuryCatalystBlockEntity blockEntity2 = (MercuryCatalystBlockEntity)blockEntity;
            float fillLevel = (float)blockEntity2.mercuryFluxStorage.getEnergyStored() / (float)blockEntity2.mercuryFluxStorage.getMaxEnergyStored();
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getItemColor(ItemStack pStack, int pTintIndex) {
        if (pStack.has((DataComponentType)DataComponentRegistry.MERCURY_FLUX_STORAGE.get())) {
            float fillLevel = (float)((Integer)pStack.get((DataComponentType)DataComponentRegistry.MERCURY_FLUX_STORAGE.get())).intValue() / 50000.0f;
            return MercuryCatalystBlock.getColorFromFillLevel(fillLevel);
        }
        return 0xFFFFFF;
    }

    public static int getColorFromFillLevel(float fillLevel) {
        int r = (int)((double)(1.0f - fillLevel) * 255.0);
        int g = (int)((double)(1.0f - fillLevel) * 255.0);
        int b = 255;
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        int rgb = r << 16 | g << 8 | b;
        return rgb;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (this.itemHandlerBehaviour.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        this.checkPoweredState(pLevel, pPos, pState, 4);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.is(pState.getBlock())) {
            this.checkPoweredState(pLevel, pPos, pState, 2);
        }
    }

    private void checkPoweredState(Level pLevel, BlockPos pPos, BlockState pState, int pFlags) {
        boolean enabled;
        boolean bl = enabled = !pLevel.hasNeighborSignal(pPos);
        if (enabled != (Boolean)pState.getValue((Property)ENABLED)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(enabled)), pFlags);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return BlockEntityRegistry.MERCURY_CATALYST.get().create(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof MercuryCatalystBlockEntity) {
                MercuryCatalystBlockEntity blockEntity = (MercuryCatalystBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }
}

