/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;

public class DigestionRecipe
implements Recipe<ItemHandlerWithFluidRecipeInput> {
    public static final int DEFAULT_TIME = 200;
    public static final MapCodec<DigestionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedFluidIngredient.NESTED_CODEC.fieldOf("fluid").forGetter(r -> r.fluid), (App)SizedIngredient.NESTED_CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.sizedIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(r -> r.time)).apply((Applicative)instance, DigestionRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DigestionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, r -> r.fluid, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), r -> r.sizedIngredients, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.time, DigestionRecipe::new);
    protected final SizedFluidIngredient fluid;
    protected final List<SizedIngredient> sizedIngredients;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int time;

    public DigestionRecipe(SizedFluidIngredient fluid, List<SizedIngredient> sizedIngredients, ItemStack result, int time) {
        this.fluid = fluid;
        this.sizedIngredients = sizedIngredients;
        this.ingredients = sizedIngredients.stream().map(SizedIngredient::ingredient).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll);
        this.result = result;
        this.time = time;
    }

    public boolean isSpecial() {
        return true;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.DIGESTION.get();
    }

    public boolean matches(ItemHandlerWithFluidRecipeInput pContainer, @NotNull Level pLevel) {
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean fluidMatches = this.fluid.test(fluid);
        if (!fluidMatches) {
            return false;
        }
        IntArrayList visited = new IntArrayList();
        for (SizedIngredient ingredient : this.sizedIngredients) {
            boolean found = false;
            for (int i = 0; i < pContainer.size(); ++i) {
                if (visited.contains(i)) continue;
                ItemStack stack = pContainer.getItem(i);
                if (!ingredient.ingredient().test(stack) || stack.getCount() < ingredient.count()) continue;
                found = true;
                visited.add(i);
                break;
            }
            if (found) continue;
            return false;
        }
        for (int i = 0; i < pContainer.size(); ++i) {
            ItemStack stack;
            if (visited.contains(i) || (stack = pContainer.getItem(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull ItemHandlerWithFluidRecipeInput pInv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public List<SizedIngredient> getSizedIngredients() {
        return this.sizedIngredients;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ItemRegistry.DIGESTION_VAT.get());
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializerRegistry.DIGESTION.get();
    }

    public SizedFluidIngredient getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.amount();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<DigestionRecipe> {
        @NotNull
        public MapCodec<DigestionRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DigestionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

