/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter;

import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import com.klikli_dev.theurgy.content.render.outliner.Outliner;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowCaloricFluxEmitterStatus;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CaloricFluxEmitterInteractionBehaviour
implements InteractionBehaviour {
    @Override
    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof CaloricFluxEmitterBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CaloricFluxEmitterBlockEntity caloricFluxEmitter = (CaloricFluxEmitterBlockEntity)blockEntity;
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        Networking.sendTo((ServerPlayer)pPlayer, new MessageShowCaloricFluxEmitterStatus(pPos, caloricFluxEmitter.selectedPoints));
        return ItemInteractionResult.SUCCESS;
    }

    public void showStatus(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CaloricFluxEmitterBlockEntity)) {
            return;
        }
        CaloricFluxEmitterBlockEntity caloricFluxEmitter = (CaloricFluxEmitterBlockEntity)blockEntity;
        this.showOutlines(level, caloricFluxEmitter);
        this.showStatusMessage(level, player, caloricFluxEmitter);
    }

    private void showOutlines(Level level, CaloricFluxEmitterBlockEntity caloricFluxEmitter) {
        for (CaloricFluxEmitterSelectedPoint selectedPoint : caloricFluxEmitter.selectedPoints) {
            BlockPos pos = selectedPoint.getBlockPos();
            VoxelShape shape = Shapes.block();
            boolean isValid = level.getCapability(CapabilityRegistry.HEAT_RECEIVER, pos, null) != null;
            Outliner.get().showAABB(selectedPoint, shape.bounds().move(pos), 100).colored(isValid ? selectedPoint.getColor().getRGB() : 0xFF0000).lineWidth(0.0625f);
        }
    }

    private void showStatusMessage(Level level, Player player, CaloricFluxEmitterBlockEntity caloricFluxEmitter) {
        if (caloricFluxEmitter.selectedPoints.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.caloric_flux_emitter.no_selection").withStyle(ChatFormatting.RED), true);
        } else {
            CaloricFluxEmitterSelectedPoint target = caloricFluxEmitter.selectedPoints.getFirst();
            BlockState state = target.getBlockState();
            player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.caloric_flux_emitter", (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.WHITE), true);
        }
    }
}

