/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector;

import com.klikli_dev.theurgy.content.apparatus.DirectionalBlockShape;
import com.klikli_dev.theurgy.content.apparatus.logisticsitemconnector.LogisticsItemConnectorBlockEntity;
import com.klikli_dev.theurgy.content.behaviour.filter.HasFilterBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.HasWireEndPoint;
import com.klikli_dev.theurgy.logistics.Wires;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageShowLogisticsNodeStatus;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class LogisticsItemConnectorBlock
extends DirectionalBlock
implements EntityBlock,
HasWireEndPoint {
    public static final BooleanProperty HAS_FILTER = BooleanProperty.create((String)"has_filter");
    public static final DirectionalBlockShape SHAPE = new DirectionalBlockShape(2.0f, 2.0f, 8.0f);

    public LogisticsItemConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)HAS_FILTER, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof LogisticsItemConnectorBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        LogisticsItemConnectorBlockEntity blockEntity2 = (LogisticsItemConnectorBlockEntity)blockEntity;
        ItemInteractionResult result = blockEntity2.filter().useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
        if (result != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return result;
        }
        if (!pPlayer.getItemInHand(pHand).isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        Networking.sendTo((ServerPlayer)pPlayer, new MessageShowLogisticsNodeStatus(blockEntity2.getStatusHighlights()));
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE.getShape((Direction)pState.getValue((Property)FACING));
    }

    public void onRemove(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!pState.is(pNewState.getBlock()) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof HasFilterBehaviour) {
            HasFilterBehaviour hasFilterBehaviour = (HasFilterBehaviour)blockEntity;
            hasFilterBehaviour.filter().onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
        if (!(!pState.hasBlockEntity() || pState.is(pNewState.getBlock()) && pNewState.hasBlockEntity())) {
            int removedWires = Wires.get(pLevel).removeWiresFor(pPos);
            if (pLevel.isClientSide) {
                return;
            }
            Block.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.COPPER_WIRE.get(), removedWires));
            BlockEntity blockEntity2 = pLevel.getBlockEntity(pPos);
            if (blockEntity2 instanceof LogisticsItemConnectorBlockEntity) {
                LogisticsItemConnectorBlockEntity blockEntity3 = (LogisticsItemConnectorBlockEntity)blockEntity2;
                blockEntity3.leafNode().onDestroyed();
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, HAS_FILTER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        return !pLevel.getBlockState(blockpos).isAir();
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        return pFacing.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }
}

