/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier;

import com.klikli_dev.theurgy.content.apparatus.calcinationoven.CalcinationOvenBlock;
import com.klikli_dev.theurgy.content.apparatus.pyromanticbrazier.PyromanticBrazierBlock;
import com.klikli_dev.theurgy.content.capability.HeatProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyromanticBrazierBlockEntity
extends BlockEntity {
    public ItemStackHandler inventory = new Inventory();
    public HeatProvider heatProvider = () -> (Boolean)this.getBlockState().getValue((Property)PyromanticBrazierBlock.LIT);
    private int remainingLitTime;

    public PyromanticBrazierBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.PYROMANTIC_BRAZIER.get(), pPos, pBlockState);
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("inventory")) {
            this.inventory.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        }
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.isEmpty()) {
            return 0;
        }
        return pFuel.getBurnTime((RecipeType)RecipeTypeRegistry.PYROMANTIC_BRAZIER.get());
    }

    public boolean isLit() {
        return this.remainingLitTime > 0;
    }

    public void tickClient() {
    }

    public void tickServer() {
        ItemStack fuelStack;
        boolean hasFuel;
        boolean wasTurnedOnDuringThisTick = false;
        boolean wasLitAtBeginOfTick = this.isLit();
        if (wasLitAtBeginOfTick) {
            --this.remainingLitTime;
        }
        boolean bl = hasFuel = !(fuelStack = this.inventory.getStackInSlot(0)).isEmpty();
        if (!this.isLit() && hasFuel) {
            this.remainingLitTime = this.getBurnDuration(fuelStack);
            if (this.isLit()) {
                wasTurnedOnDuringThisTick = true;
                if (fuelStack.hasCraftingRemainingItem()) {
                    this.inventory.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                } else if (hasFuel) {
                    fuelStack.shrink(1);
                    if (fuelStack.isEmpty()) {
                        this.inventory.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                    }
                }
            }
        }
        if (wasLitAtBeginOfTick != this.isLit()) {
            wasTurnedOnDuringThisTick = true;
            BlockState newState = (BlockState)this.getBlockState().setValue((Property)CalcinationOvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            this.level.setBlock(this.getBlockPos(), newState, 3);
        }
        if (wasTurnedOnDuringThisTick) {
            this.setChanged();
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putShort("remainingLitTime", (short)this.remainingLitTime);
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("remainingLitTime")) {
            this.remainingLitTime = pTag.getShort("remainingLitTime");
        }
        this.readNetwork(pTag, pRegistries);
    }

    private class Inventory
    extends MonitoredItemStackHandler {
        public Inventory() {
            super(1);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return PyromanticBrazierBlockEntity.this.getBurnDuration(stack) > 0;
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            PyromanticBrazierBlockEntity.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            PyromanticBrazierBlockEntity.this.setChanged();
        }
    }
}

