/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterInteractionBehaviour;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectionBehaviour;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SulfuricFluxEmitterBlock
extends DirectionalBlock
implements EntityBlock {
    public static final MapCodec<SulfuricFluxEmitterBlock> CODEC = SulfuricFluxEmitterBlock.simpleCodec(SulfuricFluxEmitterBlock::new);
    private static final int SHAPE_LENGTH = 4;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0)).put((Object)Direction.WEST, (Object)Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)).put((Object)Direction.NORTH, (Object)Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0)).put((Object)Direction.SOUTH, (Object)Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0)).put((Object)Direction.UP, (Object)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0)).put((Object)Direction.DOWN, (Object)Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)).build());
    protected SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> selectionBehaviour = new SulfuricFluxEmitterSelectionBehaviour();
    protected SulfuricFluxEmitterInteractionBehaviour interactionBehaviour = new SulfuricFluxEmitterInteractionBehaviour();

    public SulfuricFluxEmitterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> selectionBehaviour() {
        return this.selectionBehaviour;
    }

    public SulfuricFluxEmitterInteractionBehaviour interactionBehaviour() {
        return this.interactionBehaviour;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        return this.interactionBehaviour.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(pState.getValue((Property)FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(direction.getOpposite()));
        return blockstate.is((Block)this) && blockstate.getValue((Property)FACING) == direction ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!this.canSurvive(pState, (LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        }
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        BlockState facingNeighborState = pLevel.getBlockState(pPos.relative(facing.getOpposite()));
        return facingNeighborState.isFaceSturdy((BlockGetter)pLevel, pPos, facing);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirrorIn.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return BlockEntityRegistry.SULFURIC_FLUX_EMITTER.get().create(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof SulfuricFluxEmitterBlockEntity) {
                    SulfuricFluxEmitterBlockEntity blockEntity = (SulfuricFluxEmitterBlockEntity)t;
                    blockEntity.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof SulfuricFluxEmitterBlockEntity) {
                SulfuricFluxEmitterBlockEntity blockEntity = (SulfuricFluxEmitterBlockEntity)t;
                blockEntity.tickServer();
            }
        };
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

