/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.render.cube;

import com.klikli_dev.theurgy.content.render.FluidRenderer;
import com.klikli_dev.theurgy.util.EnumUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CubeModel {
    private static final Map<Direction, CubeModel> cachedOverlays = new EnumMap<Direction, CubeModel>(Direction.class);
    private final TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
    private final boolean[] renderSides = new boolean[]{true, true, true, true, true, true};
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;

    public static CubeModel getOverlayModel(Direction side, TextureAtlasSprite sprite) {
        return cachedOverlays.computeIfAbsent(side, s -> new CubeModel().setTexture(sprite).prepSingleFaceModelSize(side));
    }

    public CubeModel setSideRender(Predicate<Direction> shouldRender) {
        for (Direction direction : EnumUtil.DIRECTIONS) {
            this.setSideRender(direction, shouldRender.test(direction));
        }
        return this;
    }

    public CubeModel setSideRender(Direction side, boolean value) {
        this.renderSides[side.ordinal()] = value;
        return this;
    }

    public CubeModel copy() {
        CubeModel copy = new CubeModel();
        System.arraycopy(this.textures, 0, copy.textures, 0, this.textures.length);
        System.arraycopy(this.renderSides, 0, copy.renderSides, 0, this.renderSides.length);
        return copy.bounds(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Nullable
    public TextureAtlasSprite getSpriteToRender(Direction side) {
        int ordinal = side.ordinal();
        return this.renderSides[ordinal] ? this.textures[ordinal] : null;
    }

    public CubeModel shrink(float amount) {
        return this.grow(-amount);
    }

    public CubeModel grow(float amount) {
        return this.bounds(this.minX - amount, this.minY - amount, this.minZ - amount, this.maxX + amount, this.maxY + amount, this.maxZ + amount);
    }

    public CubeModel xBounds(float min, float max) {
        this.minX = min;
        this.maxX = max;
        return this;
    }

    public CubeModel yBounds(float min, float max) {
        this.minY = min;
        this.maxY = max;
        return this;
    }

    public CubeModel zBounds(float min, float max) {
        this.minZ = min;
        this.maxZ = max;
        return this;
    }

    public CubeModel bounds(float min, float max) {
        return this.bounds(min, min, min, max, max, max);
    }

    public CubeModel bounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return this.xBounds(minX, maxX).yBounds(minY, maxY).zBounds(minZ, maxZ);
    }

    public CubeModel prepSingleFaceModelSize(Direction face) {
        this.bounds(0.0f, 1.0f);
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> this.yBounds(-0.01f, -0.001f);
            case Direction.UP -> this.yBounds(1.001f, 1.01f);
            case Direction.NORTH -> this.zBounds(-0.01f, -0.001f);
            case Direction.SOUTH -> this.zBounds(1.001f, 1.01f);
            case Direction.WEST -> this.xBounds(-0.01f, -0.001f);
            case Direction.EAST -> this.xBounds(1.001f, 1.01f);
        };
    }

    public CubeModel prepFlowing(@NotNull FluidStack fluid) {
        TextureAtlasSprite still = FluidRenderer.getFluidTexture(fluid, FluidRenderer.FluidTextureType.STILL);
        TextureAtlasSprite flowing = FluidRenderer.getFluidTexture(fluid, FluidRenderer.FluidTextureType.FLOWING);
        return this.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public CubeModel setTexture(Direction side, @Nullable TextureAtlasSprite sprite) {
        this.textures[side.ordinal()] = sprite;
        return this;
    }

    public CubeModel setTexture(TextureAtlasSprite tex) {
        Arrays.fill(this.textures, tex);
        return this;
    }

    public CubeModel setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
        this.textures[0] = down;
        this.textures[1] = up;
        this.textures[2] = north;
        this.textures[3] = south;
        this.textures[4] = west;
        this.textures[5] = east;
        return this;
    }

    public static interface ModelBoundsSetter {
        public CubeModel set(float var1, float var2);
    }
}

