/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.render.itemhud;

import com.klikli_dev.theurgy.config.ClientConfig;
import com.klikli_dev.theurgy.content.render.itemhud.ItemHUDProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemHUD
implements LayeredDraw.Layer {
    private static final ItemHUD instance = new ItemHUD();

    public static ItemHUD get() {
        return instance;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || minecraft.player == null || minecraft.player.isSpectator() || !((Boolean)ClientConfig.get().rendering.enableItemHUD.get()).booleanValue()) {
            return;
        }
        ItemStack stack = minecraft.player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof ItemHUDProvider)) {
            return;
        }
        ItemHUDProvider itemHUDProvider = (ItemHUDProvider)item;
        ArrayList<Component> hudTexts = new ArrayList<Component>();
        itemHUDProvider.appendHUDText((Player)minecraft.player, minecraft.hitResult, stack, (Level)minecraft.level, hudTexts);
        if (hudTexts.isEmpty()) {
            return;
        }
        Font font = minecraft.font;
        float hudScale = ((Double)ClientConfig.get().rendering.itemHUDScale.get()).floatValue();
        int yScale = (int)((float)guiGraphics.guiHeight() / hudScale);
        int start = 2 + hudTexts.size() * 9;
        int y = yScale - start;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.scale(hudScale, hudScale, hudScale);
        for (Component text : hudTexts) {
            int x = 2;
            guiGraphics.drawString(font, text, x, y, -3618616);
            y += 9;
        }
        pose.popPose();
    }
}

