/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.network.Message;
import com.klikli_dev.theurgy.util.EntityUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MessageShowCaloricFlux
implements Message {
    public static final CustomPacketPayload.Type<MessageShowCaloricFlux> TYPE = new CustomPacketPayload.Type(Theurgy.loc("show_caloric_flux"));
    public static final Color COLOR = new Color(14368519, false);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageShowCaloricFlux> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, m -> m.from, (StreamCodec)BlockPos.STREAM_CODEC, m -> m.to, (StreamCodec)Direction.STREAM_CODEC, m -> m.emitterDirection, MessageShowCaloricFlux::new);
    private final BlockPos from;
    private final BlockPos to;
    private final Direction emitterDirection;

    public MessageShowCaloricFlux(BlockPos from, BlockPos to, Direction emitterDirection) {
        this.from = from;
        this.to = to;
        this.emitterDirection = emitterDirection;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Level level = player.level();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)this.emitterDirection.getNormal());
        Vec3 from = Vec3.atCenterOf((Vec3i)this.from).subtract(normal.scale(0.5));
        Vec3 to = Vec3.atCenterOf((Vec3i)this.to);
        if (level.isLoaded(this.to) && level.isLoaded(this.from) && level.isClientSide && player.getOnPos().distSqr((Vec3i)this.from) < 225.0) {
            FollowProjectile projectile = new FollowProjectile(level, from, to, COLOR, 0.1f);
            projectile.setDeltaMovement(normal.scale((double)0.3f));
            EntityUtil.spawnEntityClientSide(level, (Entity)projectile, true);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

