/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.apparatus.mercurycatalyst.MercuryCatalystCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.DefaultMercuryFluxStorage;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import com.klikli_dev.theurgy.registry.CapabilityRegistry;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystBlockEntity
extends BlockEntity {
    public static final int CAPACITY = 50000;
    public static final int PUSH_TICK_INTERVAL = 20;
    public static final int PUSH_RATE_PER_TICK = 2;
    public ItemStackHandler inventory = new Inventory();
    public MercuryCatalystMercuryFluxStorage mercuryFluxStorage = new MercuryCatalystMercuryFluxStorage(50000);
    protected CraftingBehaviour<?, ?, ?> craftingBehaviour = new MercuryCatalystCraftingBehaviour(this, () -> this.inventory, () -> this.inventory, () -> this.mercuryFluxStorage);

    public MercuryCatalystBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.MERCURY_CATALYST.get(), pPos, pBlockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pRegistries, tag.get("mercuryFluxStorage"));
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 8);
            }
        }
    }

    public void writeNetwork(CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT(pRegistries));
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void tickServer() {
        boolean hasInput = !this.inventory.getStackInSlot(0).isEmpty();
        this.craftingBehaviour.tickServer(true, hasInput);
        if (this.getLevel().getGameTime() % 20L == 0L && ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            this.pushMercuryFlux();
        }
    }

    protected void pushMercuryFlux() {
        Collection directions = Direction.allShuffled((RandomSource)this.getLevel().getRandom());
        for (Direction direction : directions) {
            MercuryFluxStorage fluxStorage;
            if (this.mercuryFluxStorage.getEnergyStored() <= 0) break;
            BlockEntity blockEntity = this.getLevel().getBlockEntity(this.getBlockPos().relative(direction));
            if (blockEntity == null || (fluxStorage = (MercuryFluxStorage)this.level.getCapability(CapabilityRegistry.MERCURY_FLUX_HANDLER, this.getBlockPos().relative(direction), null)) == null) continue;
            int energy = this.mercuryFluxStorage.extractEnergy(40, true);
            int received = fluxStorage.receiveEnergy(energy, false);
            this.mercuryFluxStorage.extractEnergy(received, false);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        pTag.put("mercuryFluxStorage", this.mercuryFluxStorage.serializeNBT(pRegistries));
        this.craftingBehaviour.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("inventory")) {
            this.inventory.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
        }
        if (pTag.contains("mercuryFluxStorage")) {
            this.mercuryFluxStorage.deserializeNBT(pRegistries, pTag.get("mercuryFluxStorage"));
        }
        this.craftingBehaviour.loadAdditional(pTag, pRegistries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        if (pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE) != null) {
            this.mercuryFluxStorage.setEnergyStored((Integer)pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_STORAGE));
        }
        if (pComponentInput.get(DataComponentRegistry.MERCURY_CATALYST_INVENTORY) != null) {
            this.inventory.deserializeNBT((HolderLookup.Provider)this.level.registryAccess(), ((CustomData)pComponentInput.get(DataComponentRegistry.MERCURY_CATALYST_INVENTORY)).getUnsafe());
        }
        this.craftingBehaviour.applyImplicitComponents(pComponentInput);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponentRegistry.MERCURY_FLUX_STORAGE, (Object)this.mercuryFluxStorage.getEnergyStored());
        pComponents.set(DataComponentRegistry.MERCURY_CATALYST_INVENTORY, (Object)CustomData.of((CompoundTag)this.inventory.serializeNBT((HolderLookup.Provider)this.level.registryAccess())));
        this.craftingBehaviour.collectImplicitComponents(pComponents);
    }

    private class Inventory
    extends MonitoredItemStackHandler {
        public Inventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            MercuryCatalystBlockEntity.this.craftingBehaviour.onInputItemChanged(oldStack, newStack);
            MercuryCatalystBlockEntity.this.sendBlockUpdated();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return MercuryCatalystBlockEntity.this.craftingBehaviour.canProcess(stack) && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            MercuryCatalystBlockEntity.this.setChanged();
        }
    }

    public class MercuryCatalystMercuryFluxStorage
    extends DefaultMercuryFluxStorage {
        public static final int UPDATE_THRESHOLD = 100;
        private int lastUpdateLevel;

        public MercuryCatalystMercuryFluxStorage(int capacity) {
            super(capacity);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (received > 0) {
                MercuryCatalystBlockEntity.this.setChanged();
                this.trySendBlockUpdated();
            }
            return received;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (extracted > 0) {
                MercuryCatalystBlockEntity.this.setChanged();
                this.trySendBlockUpdated();
            }
            return extracted;
        }

        public void trySendBlockUpdated() {
            int currentLevel = this.getEnergyStored();
            if (Math.abs(this.lastUpdateLevel - currentLevel) > 100) {
                this.lastUpdateLevel = currentLevel;
                MercuryCatalystBlockEntity.this.sendBlockUpdated();
            }
        }
    }
}

