/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter.attribute;

import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InTagAttribute
implements ItemAttribute {
    public static final InTagAttribute DUMMY = new InTagAttribute((TagKey<Item>)ItemTags.DIRT);
    public TagKey<Item> tag;

    public InTagAttribute(TagKey<Item> tag) {
        this.tag = tag;
    }

    @Override
    public boolean appliesTo(ItemStack stack) {
        return stack.is(this.tag);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack stack) {
        return stack.getTags().map(InTagAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "in_tag";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{"#" + String.valueOf(this.tag.location())};
    }

    @Override
    public void writeNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        nbt.putString("space", this.tag.location().getNamespace());
        nbt.putString("path", this.tag.location().getPath());
    }

    @Override
    public ItemAttribute readNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        return new InTagAttribute((TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)nbt.getString("space"), (String)nbt.getString("path"))));
    }
}

