/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bakering.init;

import net.mcreator.bakering.entity.BlueberryCowEntity;
import net.mcreator.bakering.entity.StrawberryCowEntity;
import net.mcreator.bakering.entity.TurkeyEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BakeringModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"bakering");
    public static final RegistryObject<EntityType<TurkeyEntity>> TURKEY = BakeringModEntities.register("turkey", EntityType.Builder.m_20704_(TurkeyEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TurkeyEntity::new).m_20699_(0.6f, 1.0f));
    public static final RegistryObject<EntityType<StrawberryCowEntity>> STRAWBERRY_COW = BakeringModEntities.register("strawberry_cow", EntityType.Builder.m_20704_(StrawberryCowEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(StrawberryCowEntity::new).m_20699_(0.9f, 1.4f));
    public static final RegistryObject<EntityType<BlueberryCowEntity>> BLUEBERRY_COW = BakeringModEntities.register("blueberry_cow", EntityType.Builder.m_20704_(BlueberryCowEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BlueberryCowEntity::new).m_20699_(1.0f, 1.0f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TurkeyEntity.init();
            StrawberryCowEntity.init();
            BlueberryCowEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TURKEY.get(), TurkeyEntity.m_28263_().m_22265_());
        event.put((EntityType)STRAWBERRY_COW.get(), StrawberryCowEntity.createAttributes().m_22265_());
        event.put((EntityType)BLUEBERRY_COW.get(), BlueberryCowEntity.createAttributes().m_22265_());
    }
}

