/*
 * Decompiled with CFR 0.152.
 */
package net.neelesh.whackingstick.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class WhackingStickConfig {
    public static void save(int newHitSound, int enchantGlint) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("hit_sound", (Number)newHitSound);
        jsonObject.addProperty("enchantment_glint", (Number)enchantGlint);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.write(FabricLoader.getInstance().getConfigDir().resolve("whacking_stick_config.json"), gson.toJson((JsonElement)jsonObject).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int loadHitSound() {
        JsonObject jsonObject;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("whacking_stick_config.json");
        if (!Files.exists(path, new LinkOption[0])) {
            WhackingStickConfig.save(0, 0);
        }
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            jsonObject = new JsonParser().parse((Reader)bufferedReader).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return jsonObject.get("hit_sound").getAsInt();
    }

    public static int loadEnchantmentGlint() {
        JsonObject jsonObject;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("whacking_stick_config.json");
        if (!Files.exists(path, new LinkOption[0])) {
            WhackingStickConfig.save(0, 0);
        }
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            jsonObject = new JsonParser().parse((Reader)bufferedReader).getAsJsonObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return jsonObject.get("enchantment_glint").getAsInt();
    }
}

