/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcreator.recipe_generator.network.LoadPlayerAnimationMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGeneratorModPlayerAnimationAPI {
    public static final Map<String, PlayerAnimation> animations = new Object2ObjectOpenHashMap();
    public static final Map<Player, PlayerAnimation> active_animations = new Object2ObjectOpenHashMap();
    public static boolean initialized = false;

    public static void loadAnimationFile(JsonObject file) {
        JsonObject animationsObject = file.get("animations").getAsJsonObject();
        for (int i = 0; i < animationsObject.size(); ++i) {
            String animationName = (String)animationsObject.keySet().stream().toList().get(i);
            JsonObject animationObject = animationsObject.get(animationName).getAsJsonObject();
            PlayerAnimation animation = new PlayerAnimation(animationObject);
            animations.put(animationName, animation);
        }
    }

    public static class PlayerAnimation {
        public final float length;
        public boolean loop = false;
        public boolean hold_on_last_frame = false;
        public final Map<String, PlayerBone> bones;

        public PlayerAnimation(JsonObject animation) {
            this.length = animation.has("animation_length") ? animation.get("animation_length").getAsFloat() : 0.0f;
            if (animation.has("loop")) {
                JsonElement loopType = animation.get("loop");
                if (loopType.isJsonPrimitive() && loopType.getAsJsonPrimitive().isBoolean()) {
                    this.loop = loopType.getAsBoolean();
                } else if (loopType.isJsonPrimitive()) {
                    this.hold_on_last_frame = true;
                }
            }
            this.bones = new HashMap<String, PlayerBone>();
            if (animation.has("bones")) {
                JsonObject bonesObj = animation.getAsJsonObject("bones");
                for (String boneName : bonesObj.keySet()) {
                    this.bones.put(boneName, new PlayerBone(bonesObj.getAsJsonObject(boneName)));
                }
            }
        }
    }

    @EventBusSubscriber
    private static class AnimationLoader {
        private AnimationLoader() {
        }

        @SubscribeEvent
        public static void loadAnimations(PlayerEvent.PlayerLoggedInEvent event) {
            Player player;
            if (!initialized && (player = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                initialized = true;
                ServerLevel level = (ServerLevel)player2.level();
                ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
                class Output
                implements PackResources.ResourceOutput {
                    private List<JsonObject> jsonObjects;
                    private PackResources packResources;

                    public Output(List<JsonObject> jsonObjects) {
                        this.jsonObjects = jsonObjects;
                    }

                    public void setPackResources(PackResources packResources) {
                        this.packResources = packResources;
                    }

                    public void accept(ResourceLocation resourceLocation, IoSupplier<InputStream> ioSupplier) {
                        try {
                            JsonObject jsonObject = (JsonObject)new Gson().fromJson(new BufferedReader(new InputStreamReader((InputStream)ioSupplier.get(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), JsonObject.class);
                            this.jsonObjects.add(jsonObject);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                Output output = new Output(jsons);
                ResourceManager rm = level.getServer().getResourceManager();
                rm.listPacks().forEach(resource -> {
                    for (String namespace : resource.getNamespaces(PackType.SERVER_DATA)) {
                        output.setPackResources((PackResources)resource);
                        resource.listResources(PackType.SERVER_DATA, namespace, "bedrock_animations", (PackResources.ResourceOutput)output);
                    }
                });
                AnimationLoader.sendAnimationsInBatches(player2, jsons);
            }
        }

        private static void sendAnimationsInBatches(ServerPlayer player, List<JsonObject> jsons) {
            int MAX_CHARS = 30000;
            int ANIMATIONS_WRAPPER_OVERHEAD = "{\"animations\":{}}".length();
            JsonObject currentBatch = new JsonObject();
            JsonObject animationsObject = new JsonObject();
            currentBatch.add("animations", (JsonElement)animationsObject);
            int currentSize = ANIMATIONS_WRAPPER_OVERHEAD;
            int animationCount = 0;
            for (JsonObject animationJson : jsons) {
                JsonObject sourceAnimations = animationJson.getAsJsonObject("animations");
                if (sourceAnimations == null) continue;
                for (Map.Entry entry : sourceAnimations.entrySet()) {
                    JsonElement animationData;
                    String animationName = (String)entry.getKey();
                    String animationString = "\"" + animationName + "\":" + (animationData = (JsonElement)entry.getValue()).toString();
                    int animationSize = animationString.length() + 1;
                    if (currentSize + animationSize > 30000 && animationCount > 0) {
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LoadPlayerAnimationMessage(currentBatch.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        currentBatch = new JsonObject();
                        animationsObject = new JsonObject();
                        currentBatch.add("animations", (JsonElement)animationsObject);
                        currentSize = ANIMATIONS_WRAPPER_OVERHEAD;
                        animationCount = 0;
                    }
                    animationsObject.add(animationName, animationData);
                    currentSize += animationSize;
                    ++animationCount;
                }
            }
            if (animationCount > 0) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new LoadPlayerAnimationMessage(currentBatch.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class PlayerBone {
        public final List<Pair<Float, Vec3>> rotations;
        public final List<Pair<Float, Vec3>> positions;
        public final List<Pair<Float, Vec3>> scales;

        public PlayerBone(JsonObject bone) {
            this.rotations = this.parseTransform(bone, "rotation");
            this.positions = this.parseTransform(bone, "position");
            this.scales = this.parseTransform(bone, "scale");
        }

        private List<Pair<Float, Vec3>> parseTransform(JsonObject bone, String key) {
            ArrayList<Pair<Float, Vec3>> result = new ArrayList<Pair<Float, Vec3>>();
            if (!bone.has(key)) {
                return result;
            }
            JsonElement element = bone.get(key);
            if (element.isJsonArray()) {
                result.add((Pair<Float, Vec3>)Pair.of((Object)Float.valueOf(0.0f), (Object)this.parseVec3(element.getAsJsonArray())));
            } else if (element.isJsonPrimitive()) {
                float value = element.getAsFloat();
                result.add((Pair<Float, Vec3>)Pair.of((Object)Float.valueOf(0.0f), (Object)new Vec3((double)value, (double)value, (double)value)));
            } else if (element.isJsonObject()) {
                JsonObject keyframes = element.getAsJsonObject();
                for (String timeStr : keyframes.keySet()) {
                    float time = Float.parseFloat(timeStr);
                    JsonElement frameValue = keyframes.get(timeStr);
                    if (frameValue.isJsonArray()) {
                        result.add((Pair<Float, Vec3>)Pair.of((Object)Float.valueOf(time), (Object)this.parseVec3(frameValue.getAsJsonArray())));
                        continue;
                    }
                    if (!frameValue.isJsonPrimitive()) continue;
                    float value = frameValue.getAsFloat();
                    result.add((Pair<Float, Vec3>)Pair.of((Object)Float.valueOf(time), (Object)new Vec3((double)value, (double)value, (double)value)));
                }
            }
            return result;
        }

        private Vec3 parseVec3(JsonArray array) {
            return new Vec3((double)array.get(0).getAsFloat(), (double)array.get(1).getAsFloat(), (double)array.get(2).getAsFloat());
        }

        public static Vec3 interpolate(List<Pair<Float, Vec3>> keyframes, float time) {
            if (keyframes.isEmpty()) {
                return null;
            }
            if (keyframes.size() == 1) {
                return (Vec3)keyframes.get(0).getRight();
            }
            Pair<Float, Vec3> lastKeyframe = null;
            for (Pair<Float, Vec3> pair : keyframes) {
                if (!(time >= ((Float)pair.getLeft()).floatValue())) break;
                lastKeyframe = pair;
            }
            if (lastKeyframe == null) {
                return null;
            }
            Pair<Float, Vec3> nextKeyframe = null;
            for (Pair<Float, Vec3> pair : keyframes) {
                if (!(((Float)pair.getLeft()).floatValue() > time)) continue;
                nextKeyframe = pair;
                break;
            }
            if (nextKeyframe == null) {
                return (Vec3)lastKeyframe.getRight();
            }
            float f = ((Float)lastKeyframe.getLeft()).floatValue();
            float f2 = ((Float)nextKeyframe.getLeft()).floatValue();
            Vec3 v1 = (Vec3)lastKeyframe.getRight();
            Vec3 v2 = (Vec3)nextKeyframe.getRight();
            if (f == f2) {
                return v1;
            }
            float alpha = (time - f) / (f2 - f);
            return new Vec3(PlayerBone.lerp(v1.x, v2.x, alpha), PlayerBone.lerp(v1.y, v2.y, alpha), PlayerBone.lerp(v1.z, v2.z, alpha));
        }

        private static double lerp(double a, double b, float t) {
            return a + (b - a) * (double)t;
        }
    }
}

