/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.recipe_generator.init.RecipeGeneratorModScreens;
import net.mcreator.recipe_generator.network.SmithingRGUIButtonMessage;
import net.mcreator.recipe_generator.procedures.InvertedCheckKubeJSProcedure;
import net.mcreator.recipe_generator.world.inventory.SmithingRGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class SmithingRGUIScreen
extends AbstractContainerScreen<SmithingRGUIMenu>
implements RecipeGeneratorModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox recipe_name;
    EditBox file_name;
    Button button_generate;
    Button button_save;
    Button button_close;
    Button button_reload;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"recipe_generator:textures/screens/smithing_rgui.png");

    public SmithingRGUIScreen(SmithingRGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("recipe_name")) {
                this.recipe_name.setValue(stringState);
            } else if (name.equals("file_name")) {
                this.file_name.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.recipe_name.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.file_name.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"recipe_generator:textures/screens/crafting_table.png"), this.leftPos + 96, this.topPos + 34, 0.0f, 0.0f, 24, 17, 24, 17);
        guiGraphics.blit(ResourceLocation.parse((String)"recipe_generator:textures/screens/template_common.png"), this.leftPos + 24, this.topPos + 34, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"recipe_generator:textures/screens/ingot_common.png"), this.leftPos + 60, this.topPos + 34, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.recipe_name.isFocused()) {
            return this.recipe_name.keyPressed(key, b, c);
        }
        if (this.file_name.isFocused()) {
            return this.file_name.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String recipe_nameValue = this.recipe_name.getValue();
        String file_nameValue = this.file_name.getValue();
        super.resize(minecraft, width, height);
        this.recipe_name.setValue(recipe_nameValue);
        this.file_name.setValue(file_nameValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.label_recipe_name"), -129, -2, -3355393, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.label_file_name"), -129, 34, -3355393, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.label_furnace"), 69, 7, -12829636, false);
        if (InvertedCheckKubeJSProcedure.execute()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.label_kubejs_is_not_supported"), 24, 16, -65485, false);
        }
    }

    public void init() {
        super.init();
        this.recipe_name = new EditBox(this.font, this.leftPos + -128, this.topPos + 8, 118, 18, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.recipe_name"));
        this.recipe_name.setMaxLength(8192);
        this.recipe_name.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SmithingRGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "recipe_name", content, false);
            }
        });
        this.recipe_name.setHint((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.recipe_name"));
        this.addWidget((GuiEventListener)this.recipe_name);
        this.file_name = new EditBox(this.font, this.leftPos + -128, this.topPos + 44, 118, 18, (Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.file_name"));
        this.file_name.setMaxLength(8192);
        this.file_name.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SmithingRGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "file_name", content, false);
            }
        });
        this.file_name.setHint((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.file_name"));
        this.addWidget((GuiEventListener)this.file_name);
        this.button_generate = Button.builder((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.button_generate"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SmithingRGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SmithingRGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 186, this.topPos + 7, 67, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_generate);
        this.button_save = Button.builder((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.button_save"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SmithingRGUIButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SmithingRGUIButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 186, this.topPos + 34, 46, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_save);
        this.button_close = Button.builder((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.button_close"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SmithingRGUIButtonMessage(2, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SmithingRGUIButtonMessage.handleButtonAction(this.entity, 2, x, y, this.z);
        }).bounds(this.leftPos + 186, this.topPos + 142, 51, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_close);
        this.button_reload = Button.builder((Component)Component.translatable((String)"gui.recipe_generator.smithing_rgui.button_reload"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SmithingRGUIButtonMessage(3, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SmithingRGUIButtonMessage.handleButtonAction(this.entity, 3, x, y, this.z);
        }).bounds(this.leftPos + 186, this.topPos + 61, 56, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_reload);
    }
}

