/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.recipe_generator.RecipeGeneratorModPlayerAnimationAPI;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerAnimationRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private String master = null;

    public PlayerAnimationRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/player/PlayerRenderer;setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V"}, at={@At(value="RETURN")})
    private void setupRotations(AbstractClientPlayer player, PoseStack poseStack, float f, float bodyYaw, float deltaTick, float g, CallbackInfo ci) {
        Vec3 rotation;
        Vec3 position;
        if (this.master == null) {
            if (!RecipeGeneratorModPlayerAnimationAPI.animations.isEmpty()) {
                this.master = "recipe_generator";
            } else {
                return;
            }
        }
        if (!this.master.equals("recipe_generator")) {
            return;
        }
        RecipeGeneratorModPlayerAnimationAPI.PlayerAnimation animation = RecipeGeneratorModPlayerAnimationAPI.active_animations.get(player);
        if (animation == null) {
            return;
        }
        RecipeGeneratorModPlayerAnimationAPI.PlayerBone bone = animation.bones.get("body");
        if (bone == null) {
            return;
        }
        float animationProgress = player.getPersistentData().getFloat("PlayerAnimationProgress");
        Vec3 scale = RecipeGeneratorModPlayerAnimationAPI.PlayerBone.interpolate(bone.scales, animationProgress);
        if (scale != null) {
            poseStack.scale((float)scale.x, (float)scale.y, (float)scale.z);
        }
        if ((position = RecipeGeneratorModPlayerAnimationAPI.PlayerBone.interpolate(bone.positions, animationProgress)) != null) {
            poseStack.translate((float)(-position.x) * 0.1f, (float)(position.y * (double)0.1f) + 0.7f, (float)position.z * 0.1f);
        }
        if ((rotation = RecipeGeneratorModPlayerAnimationAPI.PlayerBone.interpolate(bone.rotations, animationProgress)) != null) {
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation.z));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(-rotation.y)));
            poseStack.mulPose(Axis.XP.rotationDegrees((float)(-rotation.x)));
        }
        if (position != null) {
            poseStack.translate(0.0f, -0.7f, 0.0f);
        }
    }
}

