/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator.network;

import net.mcreator.recipe_generator.RecipeGeneratorMod;
import net.mcreator.recipe_generator.procedures.ButtonRGUIOfBlock1Procedure;
import net.mcreator.recipe_generator.procedures.ButtonRGUIOfBlock2Procedure;
import net.mcreator.recipe_generator.procedures.ButtonRGUIOfBlock3Procedure;
import net.mcreator.recipe_generator.procedures.ButtonRGUIOfBlock4Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CoosingRGUIOfBlockGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CoosingRGUIOfBlockGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"recipe_generator", (String)"coosing_rgui_of_block_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CoosingRGUIOfBlockGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CoosingRGUIOfBlockGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CoosingRGUIOfBlockGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CoosingRGUIOfBlockGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> CoosingRGUIOfBlockGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ButtonRGUIOfBlock1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ButtonRGUIOfBlock2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ButtonRGUIOfBlock3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            ButtonRGUIOfBlock4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RecipeGeneratorMod.addNetworkMessage(TYPE, STREAM_CODEC, CoosingRGUIOfBlockGUIButtonMessage::handleData);
    }
}

