/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator.network;

import net.mcreator.recipe_generator.RecipeGeneratorMod;
import net.mcreator.recipe_generator.procedures.CraftingTableAdd2x2RecipeProcedure;
import net.mcreator.recipe_generator.procedures.GUIcloseProcedure;
import net.mcreator.recipe_generator.procedures.ReloadCommandProcedure;
import net.mcreator.recipe_generator.procedures.ScriptswriterProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record Crafting2x2RGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Crafting2x2RGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"recipe_generator", (String)"crafting_2x_2_rgui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Crafting2x2RGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new Crafting2x2RGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<Crafting2x2RGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(Crafting2x2RGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> Crafting2x2RGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CraftingTableAdd2x2RecipeProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            ScriptswriterProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            GUIcloseProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            ReloadCommandProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RecipeGeneratorMod.addNetworkMessage(TYPE, STREAM_CODEC, Crafting2x2RGUIButtonMessage::handleData);
    }
}

