/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.recipe_generator.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import net.mcreator.recipe_generator.RecipeGeneratorMod;
import net.mcreator.recipe_generator.RecipeGeneratorModPlayerAnimationAPI;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record LoadPlayerAnimationMessage(String animationfile) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LoadPlayerAnimationMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"recipe_generator", (String)"load_player_animation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LoadPlayerAnimationMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeUtf(message.animationfile), buffer -> new LoadPlayerAnimationMessage(buffer.readUtf()));

    public CustomPacketPayload.Type<LoadPlayerAnimationMessage> type() {
        return TYPE;
    }

    public static void handleData(LoadPlayerAnimationMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            context.enqueueWork(() -> {
                JsonObject received = null;
                try {
                    received = (JsonObject)new Gson().fromJson(message.animationfile, JsonObject.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RecipeGeneratorModPlayerAnimationAPI.loadAnimationFile(received);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        RecipeGeneratorMod.addNetworkMessage(TYPE, STREAM_CODEC, LoadPlayerAnimationMessage::handleData);
    }
}

