/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.mixin.client;

import de.rafael.modflared.Modflared;
import de.rafael.modflared.interfaces.mixin.IServerInfo;
import de.rafael.modflared.tunnel.TunnelStatus;
import java.net.InetSocketAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.network.Connection;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerStatusPinger.class})
public abstract class MultiplayerServerListPingerMixin {
    @Redirect(method={"pingServer(Lnet/minecraft/client/multiplayer/ServerData;Ljava/lang/Runnable;Ljava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;connectToServer(Ljava/net/InetSocketAddress;ZLnet/minecraft/util/debugchart/LocalSampleLogger;)Lnet/minecraft/network/Connection;"))
    public Connection connect(InetSocketAddress address, boolean useEpoll, LocalSampleLogger packetSizeLog, ServerData entry) {
        TunnelStatus result = Modflared.TUNNEL_MANAGER.handleConnect(address);
        if (result.state() == TunnelStatus.State.USE) {
            Connection connection = Connection.connectToServer((InetSocketAddress)result.runningTunnel().access().tunnelAddress(), (boolean)useEpoll, (LocalSampleLogger)packetSizeLog);
            Modflared.TUNNEL_MANAGER.prepareConnection(result, connection);
            ((IServerInfo)entry).setTunnelStatus(result);
            return connection;
        }
        return Connection.connectToServer((InetSocketAddress)address, (boolean)useEpoll, (LocalSampleLogger)packetSizeLog);
    }
}

