/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.mixin.client;

import de.rafael.modflared.interfaces.mixin.IServerInfo;
import de.rafael.modflared.tunnel.TunnelStatus;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSelectionList.OnlineServerEntry.class})
public abstract class ServerEntryMixin {
    @Shadow
    @Final
    private ServerData serverData;
    @Shadow
    @Final
    private JoinMultiplayerScreen screen;
    @Unique
    private static final ResourceLocation MODFLARED_INDICATOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"modflared", (String)"icon/indicator");

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="TAIL")})
    public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        TunnelStatus tunnelStatus = ((IServerInfo)this.serverData).getTunnelStatus();
        if (tunnelStatus != null && tunnelStatus.state() == TunnelStatus.State.USE) {
            int xOffset = entryWidth - 15;
            int yOffset = 11;
            context.blitSprite(RenderType::guiTextured, MODFLARED_INDICATOR_TEXTURE, x + xOffset, y + yOffset, 10, 10);
            int l = mouseX - x;
            int m = mouseY - y;
            if (l >= entryWidth - 15 && l <= entryWidth - 5 && m >= 9 && m <= 19) {
                this.screen.setTooltipForNextRenderPass(Collections.singletonList(Component.translatable((String)"gui.multiplayer.tunnel.status.0").withStyle(ChatFormatting.AQUA).getVisualOrderText()));
            }
        }
    }
}

