/*
 * Decompiled with CFR 0.152.
 */
package de.rafael.modflared.github;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.rafael.modflared.Modflared;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class GithubAPI {
    private static final String GITHUB_USER = "cloudflare";
    private static final String GITHUB_REPOSITORY = "cloudflared";
    private static URL GITHUB_API_ENDPOINT = null;

    @Contract(value=" -> new")
    @NotNull
    public static CompletableFuture<String> requestLatestVersion() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return GithubAPI.getJsonFromEndpoint(GITHUB_API_ENDPOINT).get("tag_name").getAsString();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to get latest cloudflared version from github", throwable);
            }
        }, Modflared.EXECUTOR);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CompletableFuture<FileHash> requestFileHash(String filename) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return GithubAPI.extractHashes(GithubAPI.getJsonFromEndpoint(GITHUB_API_ENDPOINT)).stream().filter(item -> item.file.equals(filename)).findFirst().orElseThrow();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to get file hash from github", throwable);
            }
        }, Modflared.EXECUTOR);
    }

    @NotNull
    private static @Unmodifiable List<FileHash> extractHashes(@NotNull JsonObject data) {
        return Arrays.stream(data.get("body").getAsString().split("\n")).filter(item -> item.startsWith("cloudflared-") && item.contains(":")).map(item -> {
            String[] fileData = item.split(":");
            return new FileHash(fileData[0].trim(), fileData[1].trim());
        }).toList();
    }

    private static JsonObject getJsonFromEndpoint(@NotNull URL url) throws IOException {
        URLConnection connection = url.openConnection();
        InputStream inputStream = connection.getInputStream();
        return JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
    }

    static {
        try {
            GITHUB_API_ENDPOINT = URI.create("https://api.github.com/repos/cloudflare/cloudflared/releases/latest").toURL();
        }
        catch (MalformedURLException exception) {
            Modflared.LOGGER.error("Failed to create url object of github endpoint.", (Throwable)exception);
        }
    }

    public record FileHash(String file, String hash) {
        public boolean compareTo(File file) throws IOException {
            return this.compareTo(FileHash.computeHash(file));
        }

        public boolean compareTo(@NotNull FileHash hash) {
            return Objects.equals(this.hash, hash.hash());
        }

        @NotNull
        public static FileHash computeHash(File file) throws IOException {
            ByteSource byteSource = Files.asByteSource((File)file);
            HashCode hashCode = byteSource.hash(Hashing.sha256());
            return new FileHash(file.getName(), hashCode.toString());
        }
    }
}

